/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRoleUpdate;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class PutAuthorizationRoleRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String roleId;
    private DomainOrganizationRoleUpdate body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public PutAuthorizationRoleRequest withRoleId(String roleId) {
        this.setRoleId(roleId);
        return this;
    }

    public DomainOrganizationRoleUpdate getBody() {
        return this.body;
    }

    public void setBody(DomainOrganizationRoleUpdate body) {
        this.body = body;
    }

    public PutAuthorizationRoleRequest withBody(DomainOrganizationRoleUpdate body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutAuthorizationRoleRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<DomainOrganizationRoleUpdate> withHttpInfo() {
        if (this.roleId == null) {
            throw new IllegalStateException("Missing the required parameter 'roleId' when building request for PutAuthorizationRoleRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutAuthorizationRoleRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/authorization/roles/{roleId}").withPathParameter("roleId", this.roleId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roleId, DomainOrganizationRoleUpdate body) {
        return new Builder().withRequiredParams(roleId, body);
    }

    public static class Builder {
        private final PutAuthorizationRoleRequest request = new PutAuthorizationRoleRequest();

        private Builder() {
        }

        public Builder withRoleId(String roleId) {
            this.request.setRoleId(roleId);
            return this;
        }

        public Builder withBody(DomainOrganizationRoleUpdate body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roleId, DomainOrganizationRoleUpdate body) {
            this.request.setRoleId(roleId);
            this.request.setBody(body);
            return this;
        }

        public PutAuthorizationRoleRequest build() {
            return this.request;
        }
    }
}

