/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.QueueMember;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class PostRoutingQueueUsersRequest {
    private static final Pattern JSON_MIME_PATTERN = Pattern.compile("(?i)application\\/json(;.*)?");
    private static final String[] AUTH_NAMES = new String[0];
    private String queueId;
    private List<QueueMember> body;
    private Boolean delete;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public PostRoutingQueueUsersRequest withQueueId(String queueId) {
        this.setQueueId(queueId);
        return this;
    }

    public List<QueueMember> getBody() {
        return this.body;
    }

    public void setBody(List<QueueMember> body) {
        this.body = body;
    }

    public PostRoutingQueueUsersRequest withBody(List<QueueMember> body) {
        this.setBody(body);
        return this;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public PostRoutingQueueUsersRequest withDelete(Boolean delete) {
        this.setDelete(delete);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostRoutingQueueUsersRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<List<QueueMember>> withHttpInfo() {
        if (this.queueId == null) {
            throw new IllegalStateException("Missing the required parameter 'queueId' when building request for PostRoutingQueueUsersRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostRoutingQueueUsersRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/routing/queues/{queueId}/users").withPathParameter("queueId", this.queueId).withQueryParameters("delete", "", this.delete).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud Auth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String queueId, List<QueueMember> body) {
        return new Builder().withRequiredParams(queueId, body);
    }

    public static class Builder {
        private final PostRoutingQueueUsersRequest request = new PostRoutingQueueUsersRequest();

        private Builder() {
        }

        public Builder withQueueId(String queueId) {
            this.request.setQueueId(queueId);
            return this;
        }

        public Builder withBody(List<QueueMember> body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withDelete(Boolean delete) {
            this.request.setDelete(delete);
            return this;
        }

        public Builder withRequiredParams(String queueId, List<QueueMember> body) {
            this.request.setQueueId(queueId);
            this.request.setBody(body);
            return this;
        }

        public PostRoutingQueueUsersRequest build() {
            return this.request;
        }
    }
}

