/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.Pair;
import com.mypurecloud.sdk.v2.api.request.DeleteAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteUserRolesRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationPermissionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationProductsRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRoleComparedefaultRightRoleIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.GetAuthorizationRolesRequest;
import com.mypurecloud.sdk.v2.api.request.GetUserRolesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRoleComparedefaultRightRoleIdRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRolesDefaultRequest;
import com.mypurecloud.sdk.v2.api.request.PostAuthorizationRolesRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleUsersAddRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRoleUsersRemoveRequest;
import com.mypurecloud.sdk.v2.api.request.PutAuthorizationRolesDefaultRequest;
import com.mypurecloud.sdk.v2.api.request.PutUserRolesRequest;
import com.mypurecloud.sdk.v2.model.DomainOrgRoleDifference;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRole;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRoleCreate;
import com.mypurecloud.sdk.v2.model.DomainOrganizationRoleUpdate;
import com.mypurecloud.sdk.v2.model.OrganizationProductEntityListing;
import com.mypurecloud.sdk.v2.model.OrganizationRoleEntityListing;
import com.mypurecloud.sdk.v2.model.PermissionCollectionEntityListing;
import com.mypurecloud.sdk.v2.model.UserAuthorization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AuthorizationApi {
    private final ApiClient pcapiClient;

    public AuthorizationApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteAuthorizationRole(String roleId) throws IOException, ApiException {
        this.deleteAuthorizationRoleWithHttpInfo(roleId);
    }

    public ApiResponse<Void> deleteAuthorizationRoleWithHttpInfo(String roleId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling deleteAuthorizationRole");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteAuthorizationRole(DeleteAuthorizationRoleRequest request) throws IOException, ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteAuthorizationRole(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public void deleteUserRoles(String userId) throws IOException, ApiException {
        this.deleteUserRolesWithHttpInfo(userId);
    }

    public ApiResponse<Void> deleteUserRolesWithHttpInfo(String userId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling deleteUserRoles");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/roles".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "DELETE", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, null);
    }

    public void deleteUserRoles(DeleteUserRolesRequest request) throws IOException, ApiException {
        this.pcapiClient.invokeAPI(request.withHttpInfo(), null);
    }

    public ApiResponse<Void> deleteUserRoles(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, null);
    }

    public PermissionCollectionEntityListing getAuthorizationPermissions(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getAuthorizationPermissionsWithHttpInfo(pageSize, pageNumber).getBody();
    }

    public ApiResponse<PermissionCollectionEntityListing> getAuthorizationPermissionsWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/authorization/permissions".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<PermissionCollectionEntityListing>(){});
    }

    public PermissionCollectionEntityListing getAuthorizationPermissions(GetAuthorizationPermissionsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<PermissionCollectionEntityListing>(){});
    }

    public ApiResponse<PermissionCollectionEntityListing> getAuthorizationPermissions(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<PermissionCollectionEntityListing>(){});
    }

    public OrganizationProductEntityListing getAuthorizationProducts() throws IOException, ApiException {
        return this.getAuthorizationProductsWithHttpInfo().getBody();
    }

    public ApiResponse<OrganizationProductEntityListing> getAuthorizationProductsWithHttpInfo() throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/authorization/products".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationProductEntityListing>(){});
    }

    public OrganizationProductEntityListing getAuthorizationProducts(GetAuthorizationProductsRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationProductEntityListing>(){});
    }

    public ApiResponse<OrganizationProductEntityListing> getAuthorizationProducts(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationProductEntityListing>(){});
    }

    public DomainOrganizationRole getAuthorizationRole(String roleId) throws IOException, ApiException {
        return this.getAuthorizationRoleWithHttpInfo(roleId).getBody();
    }

    public ApiResponse<DomainOrganizationRole> getAuthorizationRoleWithHttpInfo(String roleId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling getAuthorizationRole");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrganizationRole getAuthorizationRole(GetAuthorizationRoleRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
    }

    public ApiResponse<DomainOrganizationRole> getAuthorizationRole(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrgRoleDifference getAuthorizationRoleComparedefaultRightRoleId(String leftRoleId, String rightRoleId) throws IOException, ApiException {
        return this.getAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(leftRoleId, rightRoleId).getBody();
    }

    public ApiResponse<DomainOrgRoleDifference> getAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(String leftRoleId, String rightRoleId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (leftRoleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leftRoleId' when calling getAuthorizationRoleComparedefaultRightRoleId");
        }
        if (rightRoleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'rightRoleId' when calling getAuthorizationRoleComparedefaultRightRoleId");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{leftRoleId\\}", this.pcapiClient.escapeString(leftRoleId.toString())).replaceAll("\\{rightRoleId\\}", this.pcapiClient.escapeString(rightRoleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrgRoleDifference>(){});
    }

    public DomainOrgRoleDifference getAuthorizationRoleComparedefaultRightRoleId(GetAuthorizationRoleComparedefaultRightRoleIdRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrgRoleDifference>(){});
    }

    public ApiResponse<DomainOrgRoleDifference> getAuthorizationRoleComparedefaultRightRoleId(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrgRoleDifference>(){});
    }

    public OrganizationRoleEntityListing getAuthorizationRoles(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, List<Object> permission, Boolean userCount) throws IOException, ApiException {
        return this.getAuthorizationRolesWithHttpInfo(pageSize, pageNumber, sortBy, expand, nextPage, previousPage, permission, userCount).getBody();
    }

    public ApiResponse<OrganizationRoleEntityListing> getAuthorizationRolesWithHttpInfo(Integer pageSize, Integer pageNumber, String sortBy, List<Object> expand, String nextPage, String previousPage, List<Object> permission, Boolean userCount) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/authorization/roles".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageSize", pageSize));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "pageNumber", pageNumber));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "sortBy", sortBy));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "expand", expand));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "nextPage", nextPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "previousPage", previousPage));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("multi", "permission", permission));
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "userCount", userCount));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public OrganizationRoleEntityListing getAuthorizationRoles(GetAuthorizationRolesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public ApiResponse<OrganizationRoleEntityListing> getAuthorizationRoles(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public UserAuthorization getUserRoles(String userId) throws IOException, ApiException {
        return this.getUserRolesWithHttpInfo(userId).getBody();
    }

    public ApiResponse<UserAuthorization> getUserRolesWithHttpInfo(String userId) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling getUserRoles");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/roles".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "GET", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<UserAuthorization>(){});
    }

    public UserAuthorization getUserRoles(GetUserRolesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<UserAuthorization>(){});
    }

    public ApiResponse<UserAuthorization> getUserRoles(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<UserAuthorization>(){});
    }

    public DomainOrganizationRole patchAuthorizationRole(String roleId, DomainOrganizationRole body) throws IOException, ApiException {
        return this.patchAuthorizationRoleWithHttpInfo(roleId, body).getBody();
    }

    public ApiResponse<DomainOrganizationRole> patchAuthorizationRoleWithHttpInfo(String roleId, DomainOrganizationRole body) throws IOException, ApiException {
        DomainOrganizationRole pclocalVarPostBody = body;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling patchAuthorizationRole");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling patchAuthorizationRole");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PATCH", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrganizationRole patchAuthorizationRole(PatchAuthorizationRoleRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
    }

    public ApiResponse<DomainOrganizationRole> patchAuthorizationRole(ApiRequest<DomainOrganizationRole> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrgRoleDifference postAuthorizationRoleComparedefaultRightRoleId(String leftRoleId, String rightRoleId, DomainOrganizationRole body) throws IOException, ApiException {
        return this.postAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(leftRoleId, rightRoleId, body).getBody();
    }

    public ApiResponse<DomainOrgRoleDifference> postAuthorizationRoleComparedefaultRightRoleIdWithHttpInfo(String leftRoleId, String rightRoleId, DomainOrganizationRole body) throws IOException, ApiException {
        DomainOrganizationRole pclocalVarPostBody = body;
        if (leftRoleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'leftRoleId' when calling postAuthorizationRoleComparedefaultRightRoleId");
        }
        if (rightRoleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'rightRoleId' when calling postAuthorizationRoleComparedefaultRightRoleId");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling postAuthorizationRoleComparedefaultRightRoleId");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{leftRoleId\\}", this.pcapiClient.escapeString(leftRoleId.toString())).replaceAll("\\{rightRoleId\\}", this.pcapiClient.escapeString(rightRoleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrgRoleDifference>(){});
    }

    public DomainOrgRoleDifference postAuthorizationRoleComparedefaultRightRoleId(PostAuthorizationRoleComparedefaultRightRoleIdRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrgRoleDifference>(){});
    }

    public ApiResponse<DomainOrgRoleDifference> postAuthorizationRoleComparedefaultRightRoleId(ApiRequest<DomainOrganizationRole> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrgRoleDifference>(){});
    }

    public DomainOrganizationRole postAuthorizationRoles(DomainOrganizationRoleCreate body) throws IOException, ApiException {
        return this.postAuthorizationRolesWithHttpInfo(body).getBody();
    }

    public ApiResponse<DomainOrganizationRole> postAuthorizationRolesWithHttpInfo(DomainOrganizationRoleCreate body) throws IOException, ApiException {
        DomainOrganizationRoleCreate pclocalVarPostBody = body;
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling postAuthorizationRoles");
        }
        String pclocalVarPath = "/api/v2/authorization/roles".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrganizationRole postAuthorizationRoles(PostAuthorizationRolesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
    }

    public ApiResponse<DomainOrganizationRole> postAuthorizationRoles(ApiRequest<DomainOrganizationRoleCreate> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrganizationRole>(){});
    }

    public OrganizationRoleEntityListing postAuthorizationRolesDefault(Boolean force) throws IOException, ApiException {
        return this.postAuthorizationRolesDefaultWithHttpInfo(force).getBody();
    }

    public ApiResponse<OrganizationRoleEntityListing> postAuthorizationRolesDefaultWithHttpInfo(Boolean force) throws IOException, ApiException {
        Object pclocalVarPostBody = null;
        String pclocalVarPath = "/api/v2/authorization/roles/default".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        pclocalVarQueryParams.addAll(this.pcapiClient.parameterToPairs("", "force", force));
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "POST", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public OrganizationRoleEntityListing postAuthorizationRolesDefault(PostAuthorizationRolesDefaultRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public ApiResponse<OrganizationRoleEntityListing> postAuthorizationRolesDefault(ApiRequest<Void> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public DomainOrganizationRole putAuthorizationRole(String roleId, DomainOrganizationRoleUpdate body) throws IOException, ApiException {
        return this.putAuthorizationRoleWithHttpInfo(roleId, body).getBody();
    }

    public ApiResponse<DomainOrganizationRole> putAuthorizationRoleWithHttpInfo(String roleId, DomainOrganizationRoleUpdate body) throws IOException, ApiException {
        DomainOrganizationRoleUpdate pclocalVarPostBody = body;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling putAuthorizationRole");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putAuthorizationRole");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<DomainOrganizationRole>(){});
    }

    public DomainOrganizationRole putAuthorizationRole(PutAuthorizationRoleRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<DomainOrganizationRole>(){});
    }

    public ApiResponse<DomainOrganizationRole> putAuthorizationRole(ApiRequest<DomainOrganizationRoleUpdate> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<DomainOrganizationRole>(){});
    }

    public List<String> putAuthorizationRoleUsersAdd(String roleId, List<String> body) throws IOException, ApiException {
        return this.putAuthorizationRoleUsersAddWithHttpInfo(roleId, body).getBody();
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersAddWithHttpInfo(String roleId, List<String> body) throws IOException, ApiException {
        List<String> pclocalVarPostBody = body;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling putAuthorizationRoleUsersAdd");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putAuthorizationRoleUsersAdd");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}/users/add".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<List<String>>(){});
    }

    public List<String> putAuthorizationRoleUsersAdd(PutAuthorizationRoleUsersAddRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<List<String>>(){});
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersAdd(ApiRequest<List<String>> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<List<String>>(){});
    }

    public List<String> putAuthorizationRoleUsersRemove(String roleId, List<String> body) throws IOException, ApiException {
        return this.putAuthorizationRoleUsersRemoveWithHttpInfo(roleId, body).getBody();
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersRemoveWithHttpInfo(String roleId, List<String> body) throws IOException, ApiException {
        List<String> pclocalVarPostBody = body;
        if (roleId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'roleId' when calling putAuthorizationRoleUsersRemove");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putAuthorizationRoleUsersRemove");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/{roleId}/users/remove".replaceAll("\\{format\\}", "json").replaceAll("\\{roleId\\}", this.pcapiClient.escapeString(roleId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<List<String>>(){});
    }

    public List<String> putAuthorizationRoleUsersRemove(PutAuthorizationRoleUsersRemoveRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<List<String>>(){});
    }

    public ApiResponse<List<String>> putAuthorizationRoleUsersRemove(ApiRequest<List<String>> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<List<String>>(){});
    }

    public OrganizationRoleEntityListing putAuthorizationRolesDefault(List<DomainOrganizationRole> body) throws IOException, ApiException {
        return this.putAuthorizationRolesDefaultWithHttpInfo(body).getBody();
    }

    public ApiResponse<OrganizationRoleEntityListing> putAuthorizationRolesDefaultWithHttpInfo(List<DomainOrganizationRole> body) throws IOException, ApiException {
        List<DomainOrganizationRole> pclocalVarPostBody = body;
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putAuthorizationRolesDefault");
        }
        String pclocalVarPath = "/api/v2/authorization/roles/default".replaceAll("\\{format\\}", "json");
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public OrganizationRoleEntityListing putAuthorizationRolesDefault(PutAuthorizationRolesDefaultRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public ApiResponse<OrganizationRoleEntityListing> putAuthorizationRolesDefault(ApiRequest<List<DomainOrganizationRole>> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<OrganizationRoleEntityListing>(){});
    }

    public UserAuthorization putUserRoles(String userId, List<String> body) throws IOException, ApiException {
        return this.putUserRolesWithHttpInfo(userId, body).getBody();
    }

    public ApiResponse<UserAuthorization> putUserRolesWithHttpInfo(String userId, List<String> body) throws IOException, ApiException {
        List<String> pclocalVarPostBody = body;
        if (userId == null) {
            throw new IllegalArgumentException("Missing the required parameter 'userId' when calling putUserRoles");
        }
        if (body == null) {
            throw new IllegalArgumentException("Missing the required parameter 'body' when calling putUserRoles");
        }
        String pclocalVarPath = "/api/v2/users/{userId}/roles".replaceAll("\\{format\\}", "json").replaceAll("\\{userId\\}", this.pcapiClient.escapeString(userId.toString()));
        ArrayList<Pair> pclocalVarQueryParams = new ArrayList<Pair>();
        HashMap<String, String> pclocalVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> pclocalVarFormParams = new HashMap<String, Object>();
        String[] pclocalVarAccepts = new String[]{"application/json"};
        String pclocalVarAccept = this.pcapiClient.selectHeaderAccept(pclocalVarAccepts);
        String[] pclocalVarContentTypes = new String[]{"application/json"};
        String pclocalVarContentType = this.pcapiClient.selectHeaderContentType(pclocalVarContentTypes);
        String[] pclocalVarAuthNames = new String[]{"PureCloud Auth"};
        return this.pcapiClient.invokeAPIVerbose(pclocalVarPath, "PUT", pclocalVarQueryParams, pclocalVarPostBody, pclocalVarHeaderParams, pclocalVarFormParams, pclocalVarAccept, pclocalVarContentType, pclocalVarAuthNames, new TypeReference<UserAuthorization>(){});
    }

    public UserAuthorization putUserRoles(PutUserRolesRequest request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPI(request.withHttpInfo(), new TypeReference<UserAuthorization>(){});
    }

    public ApiResponse<UserAuthorization> putUserRoles(ApiRequest<List<String>> request) throws IOException, ApiException {
        return this.pcapiClient.invokeAPIVerbose(request, new TypeReference<UserAuthorization>(){});
    }
}

