/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.SendMessageBody;
import java.util.HashMap;
import java.util.Map;

public class PostChatsRoomMessagesRequest {
    private String roomJid;
    private SendMessageBody body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRoomJid() {
        return this.roomJid;
    }

    public void setRoomJid(String roomJid) {
        this.roomJid = roomJid;
    }

    public PostChatsRoomMessagesRequest withRoomJid(String roomJid) {
        this.setRoomJid(roomJid);
        return this;
    }

    public SendMessageBody getBody() {
        return this.body;
    }

    public void setBody(SendMessageBody body) {
        this.body = body;
    }

    public PostChatsRoomMessagesRequest withBody(SendMessageBody body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PostChatsRoomMessagesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<SendMessageBody> withHttpInfo() {
        if (this.roomJid == null) {
            throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomMessagesRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsRoomMessagesRequest.");
        }
        return ApiRequestBuilder.create("POST", "/api/v2/chats/rooms/{roomJid}/messages").withPathParameter("roomJid", this.roomJid).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String roomJid, SendMessageBody body) {
        return new Builder().withRequiredParams(roomJid, body);
    }

    public static class Builder {
        private final PostChatsRoomMessagesRequest request = new PostChatsRoomMessagesRequest();

        private Builder() {
        }

        public Builder withRoomJid(String roomJid) {
            this.request.setRoomJid(roomJid);
            return this;
        }

        public Builder withBody(SendMessageBody body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String roomJid, SendMessageBody body) {
            this.request.setRoomJid(roomJid);
            this.request.setBody(body);
            return this;
        }

        public PostChatsRoomMessagesRequest build() {
            if (this.request.roomJid == null) {
                throw new IllegalStateException("Missing the required parameter 'roomJid' when building request for PostChatsRoomMessagesRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PostChatsRoomMessagesRequest.");
            }
            return this.request;
        }
    }
}

