/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.WidgetDeployment;
import java.util.HashMap;
import java.util.Map;

public class PutWidgetsDeploymentRequest {
    private String deploymentId;
    private WidgetDeployment body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public PutWidgetsDeploymentRequest withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public WidgetDeployment getBody() {
        return this.body;
    }

    public void setBody(WidgetDeployment body) {
        this.body = body;
    }

    public PutWidgetsDeploymentRequest withBody(WidgetDeployment body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutWidgetsDeploymentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<WidgetDeployment> withHttpInfo() {
        if (this.deploymentId == null) {
            throw new IllegalStateException("Missing the required parameter 'deploymentId' when building request for PutWidgetsDeploymentRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWidgetsDeploymentRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/widgets/deployments/{deploymentId}").withPathParameter("deploymentId", this.deploymentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String deploymentId, WidgetDeployment body) {
        return new Builder().withRequiredParams(deploymentId, body);
    }

    public static class Builder {
        private final PutWidgetsDeploymentRequest request = new PutWidgetsDeploymentRequest();

        private Builder() {
        }

        public Builder withDeploymentId(String deploymentId) {
            this.request.setDeploymentId(deploymentId);
            return this;
        }

        public Builder withBody(WidgetDeployment body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String deploymentId, WidgetDeployment body) {
            this.request.setDeploymentId(deploymentId);
            this.request.setBody(body);
            return this;
        }

        public PutWidgetsDeploymentRequest build() {
            if (this.request.deploymentId == null) {
                throw new IllegalStateException("Missing the required parameter 'deploymentId' when building request for PutWidgetsDeploymentRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutWidgetsDeploymentRequest.");
            }
            return this.request;
        }
    }
}

