/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.DeleteChatsRoomMessageRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteChatsRoomParticipantRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteChatsRoomPinnedmessageRequest;
import com.mypurecloud.sdk.v2.api.request.DeleteChatsUserMessageRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsMessageRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsRoomMessageRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsRoomMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsRoomRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsThreadMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsUserMessageRequest;
import com.mypurecloud.sdk.v2.api.request.GetChatsUserMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.PatchChatsRoomMessageRequest;
import com.mypurecloud.sdk.v2.api.request.PatchChatsRoomRequest;
import com.mypurecloud.sdk.v2.api.request.PatchChatsSettingsRequest;
import com.mypurecloud.sdk.v2.api.request.PatchChatsUserMessageRequest;
import com.mypurecloud.sdk.v2.api.request.PostChatsRoomMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.PostChatsRoomParticipantRequest;
import com.mypurecloud.sdk.v2.api.request.PostChatsRoomPinnedmessagesRequest;
import com.mypurecloud.sdk.v2.api.request.PostChatsRoomsRequest;
import com.mypurecloud.sdk.v2.api.request.PostChatsUserMessagesRequest;
import com.mypurecloud.sdk.v2.api.request.PutChatsSettingsRequest;
import com.mypurecloud.sdk.v2.model.ChatMessageEntityListing;
import com.mypurecloud.sdk.v2.model.ChatMessageResponse;
import com.mypurecloud.sdk.v2.model.ChatSendMessageResponse;
import com.mypurecloud.sdk.v2.model.ChatSettings;
import com.mypurecloud.sdk.v2.model.CreateRoomRequest;
import com.mypurecloud.sdk.v2.model.CreateRoomResponse;
import com.mypurecloud.sdk.v2.model.PinnedMessageRequest;
import com.mypurecloud.sdk.v2.model.Room;
import com.mypurecloud.sdk.v2.model.RoomUpdateRequest;
import com.mypurecloud.sdk.v2.model.SendMessageBody;
import java.io.IOException;
import java.util.List;

public class ChatApi {
    private final ApiClient pcapiClient;

    public ChatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ChatApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public void deleteChatsRoomMessage(String roomJid, String messageId) throws IOException, ApiException {
        this.deleteChatsRoomMessage(this.createDeleteChatsRoomMessageRequest(roomJid, messageId));
    }

    public ApiResponse<Void> deleteChatsRoomMessageWithHttpInfo(String roomJid, String messageId) throws IOException {
        return this.deleteChatsRoomMessage(this.createDeleteChatsRoomMessageRequest(roomJid, messageId).withHttpInfo());
    }

    private DeleteChatsRoomMessageRequest createDeleteChatsRoomMessageRequest(String roomJid, String messageId) {
        return DeleteChatsRoomMessageRequest.builder().withRoomJid(roomJid).withMessageId(messageId).build();
    }

    public void deleteChatsRoomMessage(DeleteChatsRoomMessageRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteChatsRoomMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteChatsRoomParticipant(String roomJid, String userId) throws IOException, ApiException {
        this.deleteChatsRoomParticipant(this.createDeleteChatsRoomParticipantRequest(roomJid, userId));
    }

    public ApiResponse<Void> deleteChatsRoomParticipantWithHttpInfo(String roomJid, String userId) throws IOException {
        return this.deleteChatsRoomParticipant(this.createDeleteChatsRoomParticipantRequest(roomJid, userId).withHttpInfo());
    }

    private DeleteChatsRoomParticipantRequest createDeleteChatsRoomParticipantRequest(String roomJid, String userId) {
        return DeleteChatsRoomParticipantRequest.builder().withRoomJid(roomJid).withUserId(userId).build();
    }

    public void deleteChatsRoomParticipant(DeleteChatsRoomParticipantRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteChatsRoomParticipant(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteChatsRoomPinnedmessage(String roomJid, String pinnedMessageId) throws IOException, ApiException {
        this.deleteChatsRoomPinnedmessage(this.createDeleteChatsRoomPinnedmessageRequest(roomJid, pinnedMessageId));
    }

    public ApiResponse<Void> deleteChatsRoomPinnedmessageWithHttpInfo(String roomJid, String pinnedMessageId) throws IOException {
        return this.deleteChatsRoomPinnedmessage(this.createDeleteChatsRoomPinnedmessageRequest(roomJid, pinnedMessageId).withHttpInfo());
    }

    private DeleteChatsRoomPinnedmessageRequest createDeleteChatsRoomPinnedmessageRequest(String roomJid, String pinnedMessageId) {
        return DeleteChatsRoomPinnedmessageRequest.builder().withRoomJid(roomJid).withPinnedMessageId(pinnedMessageId).build();
    }

    public void deleteChatsRoomPinnedmessage(DeleteChatsRoomPinnedmessageRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteChatsRoomPinnedmessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void deleteChatsUserMessage(String userId, String messageId) throws IOException, ApiException {
        this.deleteChatsUserMessage(this.createDeleteChatsUserMessageRequest(userId, messageId));
    }

    public ApiResponse<Void> deleteChatsUserMessageWithHttpInfo(String userId, String messageId) throws IOException {
        return this.deleteChatsUserMessage(this.createDeleteChatsUserMessageRequest(userId, messageId).withHttpInfo());
    }

    private DeleteChatsUserMessageRequest createDeleteChatsUserMessageRequest(String userId, String messageId) {
        return DeleteChatsUserMessageRequest.builder().withUserId(userId).withMessageId(messageId).build();
    }

    public void deleteChatsUserMessage(DeleteChatsUserMessageRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> deleteChatsUserMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageResponse getChatsMessage(String messageId) throws IOException, ApiException {
        return this.getChatsMessage(this.createGetChatsMessageRequest(messageId));
    }

    public ApiResponse<ChatMessageResponse> getChatsMessageWithHttpInfo(String messageId) throws IOException {
        return this.getChatsMessage(this.createGetChatsMessageRequest(messageId).withHttpInfo());
    }

    private GetChatsMessageRequest createGetChatsMessageRequest(String messageId) {
        return GetChatsMessageRequest.builder().withMessageId(messageId).build();
    }

    public ChatMessageResponse getChatsMessage(GetChatsMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageResponse> getChatsMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public Room getChatsRoom(String roomJid) throws IOException, ApiException {
        return this.getChatsRoom(this.createGetChatsRoomRequest(roomJid));
    }

    public ApiResponse<Room> getChatsRoomWithHttpInfo(String roomJid) throws IOException {
        return this.getChatsRoom(this.createGetChatsRoomRequest(roomJid).withHttpInfo());
    }

    private GetChatsRoomRequest createGetChatsRoomRequest(String roomJid) {
        return GetChatsRoomRequest.builder().withRoomJid(roomJid).build();
    }

    public Room getChatsRoom(GetChatsRoomRequest request) throws IOException, ApiException {
        try {
            ApiResponse<Room> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<Room>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<Room> getChatsRoom(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<Room>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageEntityListing getChatsRoomMessage(String roomJid, String messageIds) throws IOException, ApiException {
        return this.getChatsRoomMessage(this.createGetChatsRoomMessageRequest(roomJid, messageIds));
    }

    public ApiResponse<ChatMessageEntityListing> getChatsRoomMessageWithHttpInfo(String roomJid, String messageIds) throws IOException {
        return this.getChatsRoomMessage(this.createGetChatsRoomMessageRequest(roomJid, messageIds).withHttpInfo());
    }

    private GetChatsRoomMessageRequest createGetChatsRoomMessageRequest(String roomJid, String messageIds) {
        return GetChatsRoomMessageRequest.builder().withRoomJid(roomJid).withMessageIds(messageIds).build();
    }

    public ChatMessageEntityListing getChatsRoomMessage(GetChatsRoomMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageEntityListing> getChatsRoomMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageEntityListing getChatsRoomMessages(String roomJid, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException, ApiException {
        return this.getChatsRoomMessages(this.createGetChatsRoomMessagesRequest(roomJid, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after));
    }

    public ApiResponse<ChatMessageEntityListing> getChatsRoomMessagesWithHttpInfo(String roomJid, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException {
        return this.getChatsRoomMessages(this.createGetChatsRoomMessagesRequest(roomJid, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after).withHttpInfo());
    }

    private GetChatsRoomMessagesRequest createGetChatsRoomMessagesRequest(String roomJid, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) {
        return GetChatsRoomMessagesRequest.builder().withRoomJid(roomJid).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).withLimit(limit).withBefore(before).withAfter(after).build();
    }

    public ChatMessageEntityListing getChatsRoomMessages(GetChatsRoomMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageEntityListing> getChatsRoomMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSettings getChatsSettings() throws IOException, ApiException {
        return this.getChatsSettings(this.createGetChatsSettingsRequest());
    }

    public ApiResponse<ChatSettings> getChatsSettingsWithHttpInfo() throws IOException {
        return this.getChatsSettings(this.createGetChatsSettingsRequest().withHttpInfo());
    }

    private GetChatsSettingsRequest createGetChatsSettingsRequest() {
        return GetChatsSettingsRequest.builder().build();
    }

    public ChatSettings getChatsSettings(GetChatsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> getChatsSettings(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageEntityListing getChatsThreadMessages(String threadId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException, ApiException {
        return this.getChatsThreadMessages(this.createGetChatsThreadMessagesRequest(threadId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after));
    }

    public ApiResponse<ChatMessageEntityListing> getChatsThreadMessagesWithHttpInfo(String threadId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException {
        return this.getChatsThreadMessages(this.createGetChatsThreadMessagesRequest(threadId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after).withHttpInfo());
    }

    private GetChatsThreadMessagesRequest createGetChatsThreadMessagesRequest(String threadId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) {
        return GetChatsThreadMessagesRequest.builder().withThreadId(threadId).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).withLimit(limit).withBefore(before).withAfter(after).build();
    }

    public ChatMessageEntityListing getChatsThreadMessages(GetChatsThreadMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageEntityListing> getChatsThreadMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageEntityListing getChatsUserMessage(String userId, String messageIds) throws IOException, ApiException {
        return this.getChatsUserMessage(this.createGetChatsUserMessageRequest(userId, messageIds));
    }

    public ApiResponse<ChatMessageEntityListing> getChatsUserMessageWithHttpInfo(String userId, String messageIds) throws IOException {
        return this.getChatsUserMessage(this.createGetChatsUserMessageRequest(userId, messageIds).withHttpInfo());
    }

    private GetChatsUserMessageRequest createGetChatsUserMessageRequest(String userId, String messageIds) {
        return GetChatsUserMessageRequest.builder().withUserId(userId).withMessageIds(messageIds).build();
    }

    public ChatMessageEntityListing getChatsUserMessage(GetChatsUserMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageEntityListing> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageEntityListing>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageEntityListing> getChatsUserMessage(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageEntityListing>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatMessageResponse getChatsUserMessages(String userId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException, ApiException {
        return this.getChatsUserMessages(this.createGetChatsUserMessagesRequest(userId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after));
    }

    public ApiResponse<ChatMessageResponse> getChatsUserMessagesWithHttpInfo(String userId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) throws IOException {
        return this.getChatsUserMessages(this.createGetChatsUserMessagesRequest(userId, pageSize, pageNumber, sortBy, expand, nextPage, previousPage, limit, before, after).withHttpInfo());
    }

    private GetChatsUserMessagesRequest createGetChatsUserMessagesRequest(String userId, Integer pageSize, Integer pageNumber, String sortBy, List<String> expand, String nextPage, String previousPage, String limit, String before, String after) {
        return GetChatsUserMessagesRequest.builder().withUserId(userId).withPageSize(pageSize).withPageNumber(pageNumber).withSortBy(sortBy).withExpand(expand).withNextPage(nextPage).withPreviousPage(previousPage).withLimit(limit).withBefore(before).withAfter(after).build();
    }

    public ChatMessageResponse getChatsUserMessages(GetChatsUserMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatMessageResponse> getChatsUserMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void patchChatsRoom(String roomJid, RoomUpdateRequest body) throws IOException, ApiException {
        this.patchChatsRoom(this.createPatchChatsRoomRequest(roomJid, body));
    }

    public ApiResponse<Void> patchChatsRoomWithHttpInfo(String roomJid, RoomUpdateRequest body) throws IOException {
        return this.patchChatsRoom(this.createPatchChatsRoomRequest(roomJid, body).withHttpInfo());
    }

    private PatchChatsRoomRequest createPatchChatsRoomRequest(String roomJid, RoomUpdateRequest body) {
        return PatchChatsRoomRequest.builder().withRoomJid(roomJid).withBody(body).build();
    }

    public void patchChatsRoom(PatchChatsRoomRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> patchChatsRoom(ApiRequest<RoomUpdateRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSendMessageResponse patchChatsRoomMessage(String roomJid, String messageId, SendMessageBody body) throws IOException, ApiException {
        return this.patchChatsRoomMessage(this.createPatchChatsRoomMessageRequest(roomJid, messageId, body));
    }

    public ApiResponse<ChatSendMessageResponse> patchChatsRoomMessageWithHttpInfo(String roomJid, String messageId, SendMessageBody body) throws IOException {
        return this.patchChatsRoomMessage(this.createPatchChatsRoomMessageRequest(roomJid, messageId, body).withHttpInfo());
    }

    private PatchChatsRoomMessageRequest createPatchChatsRoomMessageRequest(String roomJid, String messageId, SendMessageBody body) {
        return PatchChatsRoomMessageRequest.builder().withRoomJid(roomJid).withMessageId(messageId).withBody(body).build();
    }

    public ChatSendMessageResponse patchChatsRoomMessage(PatchChatsRoomMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSendMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSendMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSendMessageResponse> patchChatsRoomMessage(ApiRequest<SendMessageBody> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSendMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSettings patchChatsSettings(ChatSettings body) throws IOException, ApiException {
        return this.patchChatsSettings(this.createPatchChatsSettingsRequest(body));
    }

    public ApiResponse<ChatSettings> patchChatsSettingsWithHttpInfo(ChatSettings body) throws IOException {
        return this.patchChatsSettings(this.createPatchChatsSettingsRequest(body).withHttpInfo());
    }

    private PatchChatsSettingsRequest createPatchChatsSettingsRequest(ChatSettings body) {
        return PatchChatsSettingsRequest.builder().withBody(body).build();
    }

    public ChatSettings patchChatsSettings(PatchChatsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> patchChatsSettings(ApiRequest<ChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSendMessageResponse patchChatsUserMessage(String userId, String messageId, SendMessageBody body) throws IOException, ApiException {
        return this.patchChatsUserMessage(this.createPatchChatsUserMessageRequest(userId, messageId, body));
    }

    public ApiResponse<ChatSendMessageResponse> patchChatsUserMessageWithHttpInfo(String userId, String messageId, SendMessageBody body) throws IOException {
        return this.patchChatsUserMessage(this.createPatchChatsUserMessageRequest(userId, messageId, body).withHttpInfo());
    }

    private PatchChatsUserMessageRequest createPatchChatsUserMessageRequest(String userId, String messageId, SendMessageBody body) {
        return PatchChatsUserMessageRequest.builder().withUserId(userId).withMessageId(messageId).withBody(body).build();
    }

    public ChatSendMessageResponse patchChatsUserMessage(PatchChatsUserMessageRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSendMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSendMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSendMessageResponse> patchChatsUserMessage(ApiRequest<SendMessageBody> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSendMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSendMessageResponse postChatsRoomMessages(String roomJid, SendMessageBody body) throws IOException, ApiException {
        return this.postChatsRoomMessages(this.createPostChatsRoomMessagesRequest(roomJid, body));
    }

    public ApiResponse<ChatSendMessageResponse> postChatsRoomMessagesWithHttpInfo(String roomJid, SendMessageBody body) throws IOException {
        return this.postChatsRoomMessages(this.createPostChatsRoomMessagesRequest(roomJid, body).withHttpInfo());
    }

    private PostChatsRoomMessagesRequest createPostChatsRoomMessagesRequest(String roomJid, SendMessageBody body) {
        return PostChatsRoomMessagesRequest.builder().withRoomJid(roomJid).withBody(body).build();
    }

    public ChatSendMessageResponse postChatsRoomMessages(PostChatsRoomMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSendMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSendMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSendMessageResponse> postChatsRoomMessages(ApiRequest<SendMessageBody> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSendMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void postChatsRoomParticipant(String roomJid, String userId) throws IOException, ApiException {
        this.postChatsRoomParticipant(this.createPostChatsRoomParticipantRequest(roomJid, userId));
    }

    public ApiResponse<Void> postChatsRoomParticipantWithHttpInfo(String roomJid, String userId) throws IOException {
        return this.postChatsRoomParticipant(this.createPostChatsRoomParticipantRequest(roomJid, userId).withHttpInfo());
    }

    private PostChatsRoomParticipantRequest createPostChatsRoomParticipantRequest(String roomJid, String userId) {
        return PostChatsRoomParticipantRequest.builder().withRoomJid(roomJid).withUserId(userId).build();
    }

    public void postChatsRoomParticipant(PostChatsRoomParticipantRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> postChatsRoomParticipant(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public void postChatsRoomPinnedmessages(String roomJid, PinnedMessageRequest body) throws IOException, ApiException {
        this.postChatsRoomPinnedmessages(this.createPostChatsRoomPinnedmessagesRequest(roomJid, body));
    }

    public ApiResponse<Void> postChatsRoomPinnedmessagesWithHttpInfo(String roomJid, PinnedMessageRequest body) throws IOException {
        return this.postChatsRoomPinnedmessages(this.createPostChatsRoomPinnedmessagesRequest(roomJid, body).withHttpInfo());
    }

    private PostChatsRoomPinnedmessagesRequest createPostChatsRoomPinnedmessagesRequest(String roomJid, PinnedMessageRequest body) {
        return PostChatsRoomPinnedmessagesRequest.builder().withRoomJid(roomJid).withBody(body).build();
    }

    public void postChatsRoomPinnedmessages(PostChatsRoomPinnedmessagesRequest request) throws IOException, ApiException {
        block2: {
            try {
                ApiResponse apiResponse = this.pcapiClient.invoke(request.withHttpInfo(), null);
            }
            catch (ApiException | IOException exception) {
                if (!this.pcapiClient.getShouldThrowErrors()) break block2;
                throw exception;
            }
        }
    }

    public ApiResponse<Void> postChatsRoomPinnedmessages(ApiRequest<PinnedMessageRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, null);
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public CreateRoomResponse postChatsRooms(CreateRoomRequest body) throws IOException, ApiException {
        return this.postChatsRooms(this.createPostChatsRoomsRequest(body));
    }

    public ApiResponse<CreateRoomResponse> postChatsRoomsWithHttpInfo(CreateRoomRequest body) throws IOException {
        return this.postChatsRooms(this.createPostChatsRoomsRequest(body).withHttpInfo());
    }

    private PostChatsRoomsRequest createPostChatsRoomsRequest(CreateRoomRequest body) {
        return PostChatsRoomsRequest.builder().withBody(body).build();
    }

    public CreateRoomResponse postChatsRooms(PostChatsRoomsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<CreateRoomResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<CreateRoomResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<CreateRoomResponse> postChatsRooms(ApiRequest<CreateRoomRequest> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<CreateRoomResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSendMessageResponse postChatsUserMessages(String userId, SendMessageBody body) throws IOException, ApiException {
        return this.postChatsUserMessages(this.createPostChatsUserMessagesRequest(userId, body));
    }

    public ApiResponse<ChatSendMessageResponse> postChatsUserMessagesWithHttpInfo(String userId, SendMessageBody body) throws IOException {
        return this.postChatsUserMessages(this.createPostChatsUserMessagesRequest(userId, body).withHttpInfo());
    }

    private PostChatsUserMessagesRequest createPostChatsUserMessagesRequest(String userId, SendMessageBody body) {
        return PostChatsUserMessagesRequest.builder().withUserId(userId).withBody(body).build();
    }

    public ChatSendMessageResponse postChatsUserMessages(PostChatsUserMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSendMessageResponse> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSendMessageResponse>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSendMessageResponse> postChatsUserMessages(ApiRequest<SendMessageBody> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSendMessageResponse>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }

    public ChatSettings putChatsSettings(ChatSettings body) throws IOException, ApiException {
        return this.putChatsSettings(this.createPutChatsSettingsRequest(body));
    }

    public ApiResponse<ChatSettings> putChatsSettingsWithHttpInfo(ChatSettings body) throws IOException {
        return this.putChatsSettings(this.createPutChatsSettingsRequest(body).withHttpInfo());
    }

    private PutChatsSettingsRequest createPutChatsSettingsRequest(ChatSettings body) {
        return PutChatsSettingsRequest.builder().withBody(body).build();
    }

    public ChatSettings putChatsSettings(PutChatsSettingsRequest request) throws IOException, ApiException {
        try {
            ApiResponse<ChatSettings> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<ChatSettings>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<ChatSettings> putChatsSettings(ApiRequest<ChatSettings> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<ChatSettings>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

