/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AsyncConversationQuery;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class RecordingJobsQuery
implements Serializable {
    private ActionEnum action = null;
    private Date actionDate = null;
    private Integer actionAge = null;
    private Date screenRecordingActionDate = null;
    private Integer screenRecordingActionAge = null;
    private String integrationId = null;
    private Boolean includeRecordingsWithSensitiveData = null;
    private Boolean includeScreenRecordings = null;
    private Boolean clearExport = null;
    private AsyncConversationQuery conversationQuery = null;

    public RecordingJobsQuery action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Operation to perform bulk task. If the operation will cause the delete date of a recording to be older than the export date, the export date will be adjusted to the delete date.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public RecordingJobsQuery actionDate(Date actionDate) {
        this.actionDate = actionDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the action will be performed. If screenRecordingActionDate is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="actionDate")
    public Date getActionDate() {
        return this.actionDate;
    }

    public void setActionDate(Date actionDate) {
        this.actionDate = actionDate;
    }

    public RecordingJobsQuery actionAge(Integer actionAge) {
        this.actionAge = actionAge;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days after each recording's creation date when the action will be performed. If screenRecordingActionAge is also provided, this value is only used for non-screen recordings. Otherwise this value is used for all recordings.")
    @JsonProperty(value="actionAge")
    public Integer getActionAge() {
        return this.actionAge;
    }

    public void setActionAge(Integer actionAge) {
        this.actionAge = actionAge;
    }

    public RecordingJobsQuery screenRecordingActionDate(Date screenRecordingActionDate) {
        this.screenRecordingActionDate = screenRecordingActionDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The date when the action will be performed for screen recordings. If this is provided then includeScreenRecordings must be true. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="screenRecordingActionDate")
    public Date getScreenRecordingActionDate() {
        return this.screenRecordingActionDate;
    }

    public void setScreenRecordingActionDate(Date screenRecordingActionDate) {
        this.screenRecordingActionDate = screenRecordingActionDate;
    }

    public RecordingJobsQuery screenRecordingActionAge(Integer screenRecordingActionAge) {
        this.screenRecordingActionAge = screenRecordingActionAge;
        return this;
    }

    @ApiModelProperty(example="null", value="The number of days after each screen recording's creation date when the action will be performed. If this is provided then includeScreenRecordings must be true.")
    @JsonProperty(value="screenRecordingActionAge")
    public Integer getScreenRecordingActionAge() {
        return this.screenRecordingActionAge;
    }

    public void setScreenRecordingActionAge(Integer screenRecordingActionAge) {
        this.screenRecordingActionAge = screenRecordingActionAge;
    }

    public RecordingJobsQuery integrationId(String integrationId) {
        this.integrationId = integrationId;
        return this;
    }

    @ApiModelProperty(example="null", value="IntegrationId to Access AWS S3 bucket for bulk recording exports. This field is required and used only for EXPORT action.")
    @JsonProperty(value="integrationId")
    public String getIntegrationId() {
        return this.integrationId;
    }

    public void setIntegrationId(String integrationId) {
        this.integrationId = integrationId;
    }

    public RecordingJobsQuery includeRecordingsWithSensitiveData(Boolean includeRecordingsWithSensitiveData) {
        this.includeRecordingsWithSensitiveData = includeRecordingsWithSensitiveData;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to include recordings with PCI DSS and/or PII data, default value = false ")
    @JsonProperty(value="includeRecordingsWithSensitiveData")
    public Boolean getIncludeRecordingsWithSensitiveData() {
        return this.includeRecordingsWithSensitiveData;
    }

    public void setIncludeRecordingsWithSensitiveData(Boolean includeRecordingsWithSensitiveData) {
        this.includeRecordingsWithSensitiveData = includeRecordingsWithSensitiveData;
    }

    public RecordingJobsQuery includeScreenRecordings(Boolean includeScreenRecordings) {
        this.includeScreenRecordings = includeScreenRecordings;
        return this;
    }

    @ApiModelProperty(example="null", value="Whether to include Screen recordings for the action, default value = true ")
    @JsonProperty(value="includeScreenRecordings")
    public Boolean getIncludeScreenRecordings() {
        return this.includeScreenRecordings;
    }

    public void setIncludeScreenRecordings(Boolean includeScreenRecordings) {
        this.includeScreenRecordings = includeScreenRecordings;
    }

    public RecordingJobsQuery clearExport(Boolean clearExport) {
        this.clearExport = clearExport;
        return this;
    }

    @ApiModelProperty(example="null", value="For DELETE action, setting this to true will clear any pending exports for recordings. This field is not used for EXPORT action. Default value = false")
    @JsonProperty(value="clearExport")
    public Boolean getClearExport() {
        return this.clearExport;
    }

    public void setClearExport(Boolean clearExport) {
        this.clearExport = clearExport;
    }

    public RecordingJobsQuery conversationQuery(AsyncConversationQuery conversationQuery) {
        this.conversationQuery = conversationQuery;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Conversation Query. Note: After the recording is created, it might take up to 48 hours for the recording to be included in the submitted job query.  This result depends on the analytics data lake job completion. See also: https://developer.genesys.cloud/analyticsdatamanagement/analytics/jobs/conversation-details-job#data-availability")
    @JsonProperty(value="conversationQuery")
    public AsyncConversationQuery getConversationQuery() {
        return this.conversationQuery;
    }

    public void setConversationQuery(AsyncConversationQuery conversationQuery) {
        this.conversationQuery = conversationQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingJobsQuery recordingJobsQuery = (RecordingJobsQuery)o;
        return Objects.equals((Object)this.action, (Object)recordingJobsQuery.action) && Objects.equals(this.actionDate, recordingJobsQuery.actionDate) && Objects.equals(this.actionAge, recordingJobsQuery.actionAge) && Objects.equals(this.screenRecordingActionDate, recordingJobsQuery.screenRecordingActionDate) && Objects.equals(this.screenRecordingActionAge, recordingJobsQuery.screenRecordingActionAge) && Objects.equals(this.integrationId, recordingJobsQuery.integrationId) && Objects.equals(this.includeRecordingsWithSensitiveData, recordingJobsQuery.includeRecordingsWithSensitiveData) && Objects.equals(this.includeScreenRecordings, recordingJobsQuery.includeScreenRecordings) && Objects.equals(this.clearExport, recordingJobsQuery.clearExport) && Objects.equals(this.conversationQuery, recordingJobsQuery.conversationQuery);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.action, this.actionDate, this.actionAge, this.screenRecordingActionDate, this.screenRecordingActionAge, this.integrationId, this.includeRecordingsWithSensitiveData, this.includeScreenRecordings, this.clearExport, this.conversationQuery});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingJobsQuery {\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    actionDate: ").append(this.toIndentedString(this.actionDate)).append("\n");
        sb.append("    actionAge: ").append(this.toIndentedString(this.actionAge)).append("\n");
        sb.append("    screenRecordingActionDate: ").append(this.toIndentedString(this.screenRecordingActionDate)).append("\n");
        sb.append("    screenRecordingActionAge: ").append(this.toIndentedString(this.screenRecordingActionAge)).append("\n");
        sb.append("    integrationId: ").append(this.toIndentedString(this.integrationId)).append("\n");
        sb.append("    includeRecordingsWithSensitiveData: ").append(this.toIndentedString(this.includeRecordingsWithSensitiveData)).append("\n");
        sb.append("    includeScreenRecordings: ").append(this.toIndentedString(this.includeScreenRecordings)).append("\n");
        sb.append("    clearExport: ").append(this.toIndentedString(this.clearExport)).append("\n");
        sb.append("    conversationQuery: ").append(this.toIndentedString(this.conversationQuery)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DELETE("DELETE"),
        EXPORT("EXPORT");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

