/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.KnowledgeBase;
import com.mypurecloud.sdk.v2.model.KnowledgeImportJobReport;
import com.mypurecloud.sdk.v2.model.KnowledgeImportJobSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class KnowledgeImportJobResponse
implements Serializable {
    private String id = null;
    private String uploadKey = null;
    private FileTypeEnum fileType = null;
    private KnowledgeImportJobSettings settings = null;
    private StatusEnum status = null;
    private KnowledgeImportJobReport report = null;
    private KnowledgeBase knowledgeBase = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="Id of the import job")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public KnowledgeImportJobResponse uploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Upload key")
    @JsonProperty(value="uploadKey")
    public String getUploadKey() {
        return this.uploadKey;
    }

    public void setUploadKey(String uploadKey) {
        this.uploadKey = uploadKey;
    }

    public KnowledgeImportJobResponse fileType(FileTypeEnum fileType) {
        this.fileType = fileType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="File type of the document")
    @JsonProperty(value="fileType")
    public FileTypeEnum getFileType() {
        return this.fileType;
    }

    public void setFileType(FileTypeEnum fileType) {
        this.fileType = fileType;
    }

    public KnowledgeImportJobResponse settings(KnowledgeImportJobSettings settings) {
        this.settings = settings;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional optional settings")
    @JsonProperty(value="settings")
    public KnowledgeImportJobSettings getSettings() {
        return this.settings;
    }

    public void setSettings(KnowledgeImportJobSettings settings) {
        this.settings = settings;
    }

    @ApiModelProperty(example="null", value="Status of the import job")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    @ApiModelProperty(example="null", value="Report of the import job")
    @JsonProperty(value="report")
    public KnowledgeImportJobReport getReport() {
        return this.report;
    }

    @ApiModelProperty(example="null", value="Knowledge base which document import does belong to")
    @JsonProperty(value="knowledgeBase")
    public KnowledgeBase getKnowledgeBase() {
        return this.knowledgeBase;
    }

    @ApiModelProperty(example="null", value="Created date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeImportJobResponse knowledgeImportJobResponse = (KnowledgeImportJobResponse)o;
        return Objects.equals(this.id, knowledgeImportJobResponse.id) && Objects.equals(this.uploadKey, knowledgeImportJobResponse.uploadKey) && Objects.equals((Object)this.fileType, (Object)knowledgeImportJobResponse.fileType) && Objects.equals(this.settings, knowledgeImportJobResponse.settings) && Objects.equals((Object)this.status, (Object)knowledgeImportJobResponse.status) && Objects.equals(this.report, knowledgeImportJobResponse.report) && Objects.equals(this.knowledgeBase, knowledgeImportJobResponse.knowledgeBase) && Objects.equals(this.dateCreated, knowledgeImportJobResponse.dateCreated) && Objects.equals(this.dateModified, knowledgeImportJobResponse.dateModified) && Objects.equals(this.selfUri, knowledgeImportJobResponse.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.uploadKey, this.fileType, this.settings, this.status, this.report, this.knowledgeBase, this.dateCreated, this.dateModified, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeImportJobResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    uploadKey: ").append(this.toIndentedString(this.uploadKey)).append("\n");
        sb.append("    fileType: ").append(this.toIndentedString((Object)this.fileType)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    report: ").append(this.toIndentedString(this.report)).append("\n");
        sb.append("    knowledgeBase: ").append(this.toIndentedString(this.knowledgeBase)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=FileTypeEnumDeserializer.class)
    public static enum FileTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        JSON("Json"),
        CSV("Csv"),
        XLSX("Xlsx");

        private String value;

        private FileTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static FileTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (FileTypeEnum value : FileTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return FileTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATED("Created"),
        VALIDATIONINPROGRESS("ValidationInProgress"),
        VALIDATIONCOMPLETED("ValidationCompleted"),
        VALIDATIONFAILED("ValidationFailed"),
        STARTED("Started"),
        INPROGRESS("InProgress"),
        COMPLETED("Completed"),
        PARTIALCOMPLETED("PartialCompleted"),
        FAILED("Failed"),
        ABORTREQUESTED("AbortRequested"),
        ABORTED("Aborted");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    private static class FileTypeEnumDeserializer
    extends StdDeserializer<FileTypeEnum> {
        public FileTypeEnumDeserializer() {
            super(FileTypeEnumDeserializer.class);
        }

        public FileTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return FileTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

