/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Metric;
import com.mypurecloud.sdk.v2.model.Objective;
import com.mypurecloud.sdk.v2.model.PunctualityEvent;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WorkdayMetric
implements Serializable {
    private Metric metric = null;
    private Objective objective = null;
    private Integer points = null;
    private Integer maxPoints = null;
    private Double value = null;
    private List<PunctualityEvent> punctualityEvents = new ArrayList<PunctualityEvent>();

    @ApiModelProperty(example="null", value="Gamification metric")
    @JsonProperty(value="metric")
    public Metric getMetric() {
        return this.metric;
    }

    @ApiModelProperty(example="null", value="Current objective for this metric")
    @JsonProperty(value="objective")
    public Objective getObjective() {
        return this.objective;
    }

    @ApiModelProperty(example="null", value="Gamification points earned for this metric")
    @JsonProperty(value="points")
    public Integer getPoints() {
        return this.points;
    }

    @ApiModelProperty(example="null", value="The maximum Gamification points a user may earn for this metric")
    @JsonProperty(value="maxPoints")
    public Integer getMaxPoints() {
        return this.maxPoints;
    }

    @ApiModelProperty(example="null", value="Value of this metric")
    @JsonProperty(value="value")
    public Double getValue() {
        return this.value;
    }

    @ApiModelProperty(example="null", value="List of schedule activity events for punctuality metrics")
    @JsonProperty(value="punctualityEvents")
    public List<PunctualityEvent> getPunctualityEvents() {
        return this.punctualityEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkdayMetric workdayMetric = (WorkdayMetric)o;
        return Objects.equals(this.metric, workdayMetric.metric) && Objects.equals(this.objective, workdayMetric.objective) && Objects.equals(this.points, workdayMetric.points) && Objects.equals(this.maxPoints, workdayMetric.maxPoints) && Objects.equals(this.value, workdayMetric.value) && Objects.equals(this.punctualityEvents, workdayMetric.punctualityEvents);
    }

    public int hashCode() {
        return Objects.hash(this.metric, this.objective, this.points, this.maxPoints, this.value, this.punctualityEvents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkdayMetric {\n");
        sb.append("    metric: ").append(this.toIndentedString(this.metric)).append("\n");
        sb.append("    objective: ").append(this.toIndentedString(this.objective)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    maxPoints: ").append(this.toIndentedString(this.maxPoints)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    punctualityEvents: ").append(this.toIndentedString(this.punctualityEvents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

