/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class KpiResult
implements Serializable {
    private Long kpiTotalOn = null;
    private Long kpiTotalOff = null;
    private Long interactionCountOn = null;
    private Long interactionCountOff = null;
    private MediaTypeEnum mediaType = null;

    @ApiModelProperty(example="null", value="Absolute metric (in which the KPI is based) total for the interactions handled by predictive routing (GPR was on)")
    @JsonProperty(value="kpiTotalOn")
    public Long getKpiTotalOn() {
        return this.kpiTotalOn;
    }

    @ApiModelProperty(example="null", value="Absolute metric (in which the KPI is based) total for the interactions not routed by predictive routing (GPR was off)")
    @JsonProperty(value="kpiTotalOff")
    public Long getKpiTotalOff() {
        return this.kpiTotalOff;
    }

    @ApiModelProperty(example="null", value="Total interactions handled by predictive routing (GPR was on)")
    @JsonProperty(value="interactionCountOn")
    public Long getInteractionCountOn() {
        return this.interactionCountOn;
    }

    @ApiModelProperty(example="null", value="Total interactions not routed by predictive routing (GPR was off)")
    @JsonProperty(value="interactionCountOff")
    public Long getInteractionCountOff() {
        return this.interactionCountOff;
    }

    @ApiModelProperty(example="null", value="Media type used for the KPI")
    @JsonProperty(value="mediaType")
    public MediaTypeEnum getMediaType() {
        return this.mediaType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KpiResult kpiResult = (KpiResult)o;
        return Objects.equals(this.kpiTotalOn, kpiResult.kpiTotalOn) && Objects.equals(this.kpiTotalOff, kpiResult.kpiTotalOff) && Objects.equals(this.interactionCountOn, kpiResult.interactionCountOn) && Objects.equals(this.interactionCountOff, kpiResult.interactionCountOff) && Objects.equals((Object)this.mediaType, (Object)kpiResult.mediaType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kpiTotalOn, this.kpiTotalOff, this.interactionCountOn, this.interactionCountOff, this.mediaType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KpiResult {\n");
        sb.append("    kpiTotalOn: ").append(this.toIndentedString(this.kpiTotalOn)).append("\n");
        sb.append("    kpiTotalOff: ").append(this.toIndentedString(this.kpiTotalOff)).append("\n");
        sb.append("    interactionCountOn: ").append(this.toIndentedString(this.interactionCountOn)).append("\n");
        sb.append("    interactionCountOff: ").append(this.toIndentedString(this.interactionCountOff)).append("\n");
        sb.append("    mediaType: ").append(this.toIndentedString((Object)this.mediaType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MediaTypeEnumDeserializer.class)
    public static enum MediaTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        VOICE("voice"),
        EMAIL("email"),
        MESSAGE("message");

        private String value;

        private MediaTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypeEnum value : MediaTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypeEnumDeserializer
    extends StdDeserializer<MediaTypeEnum> {
        public MediaTypeEnumDeserializer() {
            super(MediaTypeEnumDeserializer.class);
        }

        public MediaTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

