/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ScimV2PatchRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchScimGroupRequest {
    private String groupId;
    private ScimV2PatchRequest body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public PatchScimGroupRequest withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public ScimV2PatchRequest getBody() {
        return this.body;
    }

    public void setBody(ScimV2PatchRequest body) {
        this.body = body;
    }

    public PatchScimGroupRequest withBody(ScimV2PatchRequest body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PatchScimGroupRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchScimGroupRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ScimV2PatchRequest> withHttpInfo() {
        if (this.groupId == null) {
            throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PatchScimGroupRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimGroupRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/scim/groups/{groupId}").withPathParameter("groupId", this.groupId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String groupId, ScimV2PatchRequest body) {
        return new Builder().withRequiredParams(groupId, body);
    }

    public static class Builder {
        private final PatchScimGroupRequest request = new PatchScimGroupRequest();

        private Builder() {
        }

        public Builder withGroupId(String groupId) {
            this.request.setGroupId(groupId);
            return this;
        }

        public Builder withBody(ScimV2PatchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String groupId, ScimV2PatchRequest body) {
            this.request.setGroupId(groupId);
            this.request.setBody(body);
            return this;
        }

        public PatchScimGroupRequest build() {
            if (this.request.groupId == null) {
                throw new IllegalStateException("Missing the required parameter 'groupId' when building request for PatchScimGroupRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimGroupRequest.");
            }
            return this.request;
        }
    }
}

