/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ImportStatusRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseImportJobRequest {
    private String knowledgeBaseId;
    private String importJobId;
    private ImportStatusRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseImportJobRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getImportJobId() {
        return this.importJobId;
    }

    public void setImportJobId(String importJobId) {
        this.importJobId = importJobId;
    }

    public PatchKnowledgeKnowledgebaseImportJobRequest withImportJobId(String importJobId) {
        this.setImportJobId(importJobId);
        return this;
    }

    public ImportStatusRequest getBody() {
        return this.body;
    }

    public void setBody(ImportStatusRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseImportJobRequest withBody(ImportStatusRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseImportJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ImportStatusRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
        }
        if (this.importJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/import/jobs/{importJobId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("importJobId", this.importJobId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String importJobId, ImportStatusRequest body) {
        return new Builder().withRequiredParams(knowledgeBaseId, importJobId, body);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseImportJobRequest request = new PatchKnowledgeKnowledgebaseImportJobRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withImportJobId(String importJobId) {
            this.request.setImportJobId(importJobId);
            return this;
        }

        public Builder withBody(ImportStatusRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String importJobId, ImportStatusRequest body) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setImportJobId(importJobId);
            this.request.setBody(body);
            return this;
        }

        public PatchKnowledgeKnowledgebaseImportJobRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
            }
            if (this.request.importJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'importJobId' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchKnowledgeKnowledgebaseImportJobRequest.");
            }
            return this.request;
        }
    }
}

