/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.Relationship;
import java.util.HashMap;
import java.util.Map;

public class PutExternalcontactsRelationshipRequest {
    private String relationshipId;
    private Relationship body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(String relationshipId) {
        this.relationshipId = relationshipId;
    }

    public PutExternalcontactsRelationshipRequest withRelationshipId(String relationshipId) {
        this.setRelationshipId(relationshipId);
        return this;
    }

    public Relationship getBody() {
        return this.body;
    }

    public void setBody(Relationship body) {
        this.body = body;
    }

    public PutExternalcontactsRelationshipRequest withBody(Relationship body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PutExternalcontactsRelationshipRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Relationship> withHttpInfo() {
        if (this.relationshipId == null) {
            throw new IllegalStateException("Missing the required parameter 'relationshipId' when building request for PutExternalcontactsRelationshipRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PutExternalcontactsRelationshipRequest.");
        }
        return ApiRequestBuilder.create("PUT", "/api/v2/externalcontacts/relationships/{relationshipId}").withPathParameter("relationshipId", this.relationshipId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String relationshipId, Relationship body) {
        return new Builder().withRequiredParams(relationshipId, body);
    }

    public static class Builder {
        private final PutExternalcontactsRelationshipRequest request = new PutExternalcontactsRelationshipRequest();

        private Builder() {
        }

        public Builder withRelationshipId(String relationshipId) {
            this.request.setRelationshipId(relationshipId);
            return this;
        }

        public Builder withBody(Relationship body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String relationshipId, Relationship body) {
            this.request.setRelationshipId(relationshipId);
            this.request.setBody(body);
            return this;
        }

        public PutExternalcontactsRelationshipRequest build() {
            if (this.request.relationshipId == null) {
                throw new IllegalStateException("Missing the required parameter 'relationshipId' when building request for PutExternalcontactsRelationshipRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PutExternalcontactsRelationshipRequest.");
            }
            return this.request;
        }
    }
}

