/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class RecordingSettings
implements Serializable {
    private Integer maxSimultaneousStreams = null;
    private Integer maxConfigurableScreenRecordingStreams = null;
    private Boolean regionalRecordingStorageEnabled = null;

    public RecordingSettings maxSimultaneousStreams(Integer maxSimultaneousStreams) {
        this.maxSimultaneousStreams = maxSimultaneousStreams;
        return this;
    }

    @ApiModelProperty(example="null", value="Maximum number of simultaneous screen recording streams")
    @JsonProperty(value="maxSimultaneousStreams")
    public Integer getMaxSimultaneousStreams() {
        return this.maxSimultaneousStreams;
    }

    public void setMaxSimultaneousStreams(Integer maxSimultaneousStreams) {
        this.maxSimultaneousStreams = maxSimultaneousStreams;
    }

    public RecordingSettings maxConfigurableScreenRecordingStreams(Integer maxConfigurableScreenRecordingStreams) {
        this.maxConfigurableScreenRecordingStreams = maxConfigurableScreenRecordingStreams;
        return this;
    }

    @ApiModelProperty(example="null", value="Upper limit that maxSimultaneousStreams can be configured")
    @JsonProperty(value="maxConfigurableScreenRecordingStreams")
    public Integer getMaxConfigurableScreenRecordingStreams() {
        return this.maxConfigurableScreenRecordingStreams;
    }

    public void setMaxConfigurableScreenRecordingStreams(Integer maxConfigurableScreenRecordingStreams) {
        this.maxConfigurableScreenRecordingStreams = maxConfigurableScreenRecordingStreams;
    }

    public RecordingSettings regionalRecordingStorageEnabled(Boolean regionalRecordingStorageEnabled) {
        this.regionalRecordingStorageEnabled = regionalRecordingStorageEnabled;
        return this;
    }

    @ApiModelProperty(example="null", value="Store call recordings in the region where they are intended to be recorded, otherwise in the organization's home region")
    @JsonProperty(value="regionalRecordingStorageEnabled")
    public Boolean getRegionalRecordingStorageEnabled() {
        return this.regionalRecordingStorageEnabled;
    }

    public void setRegionalRecordingStorageEnabled(Boolean regionalRecordingStorageEnabled) {
        this.regionalRecordingStorageEnabled = regionalRecordingStorageEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecordingSettings recordingSettings = (RecordingSettings)o;
        return Objects.equals(this.maxSimultaneousStreams, recordingSettings.maxSimultaneousStreams) && Objects.equals(this.maxConfigurableScreenRecordingStreams, recordingSettings.maxConfigurableScreenRecordingStreams) && Objects.equals(this.regionalRecordingStorageEnabled, recordingSettings.regionalRecordingStorageEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.maxSimultaneousStreams, this.maxConfigurableScreenRecordingStreams, this.regionalRecordingStorageEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RecordingSettings {\n");
        sb.append("    maxSimultaneousStreams: ").append(this.toIndentedString(this.maxSimultaneousStreams)).append("\n");
        sb.append("    maxConfigurableScreenRecordingStreams: ").append(this.toIndentedString(this.maxConfigurableScreenRecordingStreams)).append("\n");
        sb.append("    regionalRecordingStorageEnabled: ").append(this.toIndentedString(this.regionalRecordingStorageEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

