/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.AsyncApiCallback;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetTelephonyMediaregionsRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesDownloadDownloadIdRequest;
import com.mypurecloud.sdk.v2.api.request.GetTelephonySiptracesRequest;
import com.mypurecloud.sdk.v2.api.request.PostTelephonySiptracesDownloadRequest;
import com.mypurecloud.sdk.v2.model.MediaRegions;
import com.mypurecloud.sdk.v2.model.SIPSearchPublicRequest;
import com.mypurecloud.sdk.v2.model.SignedUrlResponse;
import com.mypurecloud.sdk.v2.model.SipDownloadResponse;
import com.mypurecloud.sdk.v2.model.SipSearchResult;
import java.util.concurrent.Future;

public class TelephonyApiAsync {
    private final ApiClient pcapiClient;

    public TelephonyApiAsync() {
        this(Configuration.getDefaultApiClient());
    }

    public TelephonyApiAsync(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public Future<MediaRegions> getTelephonyMediaregionsAsync(GetTelephonyMediaregionsRequest request, final AsyncApiCallback<MediaRegions> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<MediaRegions>(){}, new AsyncApiCallback<ApiResponse<MediaRegions>>(){

                @Override
                public void onCompleted(ApiResponse<MediaRegions> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        TelephonyApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<MediaRegions>> getTelephonyMediaregionsAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<MediaRegions>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<MediaRegions>(){}, new AsyncApiCallback<ApiResponse<MediaRegions>>(){

                @Override
                public void onCompleted(ApiResponse<MediaRegions> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<SipSearchResult> getTelephonySiptracesAsync(GetTelephonySiptracesRequest request, final AsyncApiCallback<SipSearchResult> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<SipSearchResult>(){}, new AsyncApiCallback<ApiResponse<SipSearchResult>>(){

                @Override
                public void onCompleted(ApiResponse<SipSearchResult> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        TelephonyApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<SipSearchResult>> getTelephonySiptracesAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<SipSearchResult>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<SipSearchResult>(){}, new AsyncApiCallback<ApiResponse<SipSearchResult>>(){

                @Override
                public void onCompleted(ApiResponse<SipSearchResult> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<SignedUrlResponse> getTelephonySiptracesDownloadDownloadIdAsync(GetTelephonySiptracesDownloadDownloadIdRequest request, final AsyncApiCallback<SignedUrlResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<SignedUrlResponse>(){}, new AsyncApiCallback<ApiResponse<SignedUrlResponse>>(){

                @Override
                public void onCompleted(ApiResponse<SignedUrlResponse> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        TelephonyApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<SignedUrlResponse>> getTelephonySiptracesDownloadDownloadIdAsync(ApiRequest<Void> request, final AsyncApiCallback<ApiResponse<SignedUrlResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<SignedUrlResponse>(){}, new AsyncApiCallback<ApiResponse<SignedUrlResponse>>(){

                @Override
                public void onCompleted(ApiResponse<SignedUrlResponse> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<SipDownloadResponse> postTelephonySiptracesDownloadAsync(PostTelephonySiptracesDownloadRequest request, final AsyncApiCallback<SipDownloadResponse> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request.withHttpInfo(), new TypeReference<SipDownloadResponse>(){}, new AsyncApiCallback<ApiResponse<SipDownloadResponse>>(){

                @Override
                public void onCompleted(ApiResponse<SipDownloadResponse> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response.getBody());
                }

                @Override
                public void onFailed(Throwable exception) {
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        TelephonyApiAsync.this.notifySuccess(future, callback, null);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    public Future<ApiResponse<SipDownloadResponse>> postTelephonySiptracesDownloadAsync(ApiRequest<SIPSearchPublicRequest> request, final AsyncApiCallback<ApiResponse<SipDownloadResponse>> callback) {
        try {
            final SettableFuture future = SettableFuture.create();
            final boolean shouldThrowErrors = this.pcapiClient.getShouldThrowErrors();
            this.pcapiClient.invokeAsync(request, new TypeReference<SipDownloadResponse>(){}, new AsyncApiCallback<ApiResponse<SipDownloadResponse>>(){

                @Override
                public void onCompleted(ApiResponse<SipDownloadResponse> response) {
                    TelephonyApiAsync.this.notifySuccess(future, callback, response);
                }

                @Override
                public void onFailed(Throwable exception) {
                    ApiResponse response;
                    if (exception instanceof ApiException) {
                        response = (ApiResponse)((Object)exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                    if (shouldThrowErrors) {
                        TelephonyApiAsync.this.notifyFailure(future, callback, exception);
                    } else {
                        response = new ApiException(exception);
                        TelephonyApiAsync.this.notifySuccess(future, callback, response);
                    }
                }
            });
            return future;
        }
        catch (Throwable exception) {
            return Futures.immediateFailedFuture((Throwable)exception);
        }
    }

    private <T> void notifySuccess(SettableFuture<T> future, AsyncApiCallback<T> callback, T result) {
        if (callback != null) {
            try {
                callback.onCompleted(result);
                future.set(result);
            }
            catch (Throwable exception) {
                future.setException(exception);
            }
        } else {
            future.set(result);
        }
    }

    private <T> void notifyFailure(SettableFuture<T> future, AsyncApiCallback<T> callback, Throwable exception) {
        if (callback != null) {
            try {
                callback.onFailed(exception);
                future.setException(exception);
            }
            catch (Throwable callbackException) {
                future.setException(callbackException);
            }
        } else {
            future.setException(exception);
        }
    }
}

