/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class DeleteKnowledgeKnowledgebaseDocumentRequest {
    private String knowledgeBaseId;
    private String documentId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public DeleteKnowledgeKnowledgebaseDocumentRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public DeleteKnowledgeKnowledgebaseDocumentRequest withDocumentId(String documentId) {
        this.setDocumentId(documentId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public DeleteKnowledgeKnowledgebaseDocumentRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseDocumentRequest.");
        }
        if (this.documentId == null) {
            throw new IllegalStateException("Missing the required parameter 'documentId' when building request for DeleteKnowledgeKnowledgebaseDocumentRequest.");
        }
        return ApiRequestBuilder.create("DELETE", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/documents/{documentId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("documentId", this.documentId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String documentId) {
        return new Builder().withRequiredParams(knowledgeBaseId, documentId);
    }

    public static class Builder {
        private final DeleteKnowledgeKnowledgebaseDocumentRequest request = new DeleteKnowledgeKnowledgebaseDocumentRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withDocumentId(String documentId) {
            this.request.setDocumentId(documentId);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String documentId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setDocumentId(documentId);
            return this;
        }

        public DeleteKnowledgeKnowledgebaseDocumentRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for DeleteKnowledgeKnowledgebaseDocumentRequest.");
            }
            if (this.request.documentId == null) {
                throw new IllegalStateException("Missing the required parameter 'documentId' when building request for DeleteKnowledgeKnowledgebaseDocumentRequest.");
            }
            return this.request;
        }
    }
}

