/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetUserGeolocationRequest {
    private String userId;
    private String clientId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public GetUserGeolocationRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public GetUserGeolocationRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetUserGeolocationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserGeolocationRequest.");
        }
        if (this.clientId == null) {
            throw new IllegalStateException("Missing the required parameter 'clientId' when building request for GetUserGeolocationRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/users/{userId}/geolocations/{clientId}").withPathParameter("userId", this.userId).withPathParameter("clientId", this.clientId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, String clientId) {
        return new Builder().withRequiredParams(userId, clientId);
    }

    public static class Builder {
        private final GetUserGeolocationRequest request = new GetUserGeolocationRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withClientId(String clientId) {
            this.request.setClientId(clientId);
            return this;
        }

        public Builder withRequiredParams(String userId, String clientId) {
            this.request.setUserId(userId);
            this.request.setClientId(clientId);
            return this;
        }

        public GetUserGeolocationRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for GetUserGeolocationRequest.");
            }
            if (this.request.clientId == null) {
                throw new IllegalStateException("Missing the required parameter 'clientId' when building request for GetUserGeolocationRequest.");
            }
            return this.request;
        }
    }
}

