/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetKnowledgeKnowledgebaseExportJobRequest {
    private String knowledgeBaseId;
    private String exportJobId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public GetKnowledgeKnowledgebaseExportJobRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getExportJobId() {
        return this.exportJobId;
    }

    public void setExportJobId(String exportJobId) {
        this.exportJobId = exportJobId;
    }

    public GetKnowledgeKnowledgebaseExportJobRequest withExportJobId(String exportJobId) {
        this.setExportJobId(exportJobId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetKnowledgeKnowledgebaseExportJobRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for GetKnowledgeKnowledgebaseExportJobRequest.");
        }
        if (this.exportJobId == null) {
            throw new IllegalStateException("Missing the required parameter 'exportJobId' when building request for GetKnowledgeKnowledgebaseExportJobRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/export/jobs/{exportJobId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("exportJobId", this.exportJobId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String exportJobId) {
        return new Builder().withRequiredParams(knowledgeBaseId, exportJobId);
    }

    public static class Builder {
        private final GetKnowledgeKnowledgebaseExportJobRequest request = new GetKnowledgeKnowledgebaseExportJobRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withExportJobId(String exportJobId) {
            this.request.setExportJobId(exportJobId);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String exportJobId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setExportJobId(exportJobId);
            return this;
        }

        public GetKnowledgeKnowledgebaseExportJobRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for GetKnowledgeKnowledgebaseExportJobRequest.");
            }
            if (this.request.exportJobId == null) {
                throw new IllegalStateException("Missing the required parameter 'exportJobId' when building request for GetKnowledgeKnowledgebaseExportJobRequest.");
            }
            return this.request;
        }
    }
}

