/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

@ApiModel(description="Represents the details of a parsed certificate.")
public class CertificateDetails
implements Serializable {
    private String issuer = null;
    private String subject = null;
    private Date expirationDate = null;
    private Date issueDate = null;
    private Boolean expired = null;
    private Boolean valid = null;
    private Boolean signatureValid = null;

    public CertificateDetails issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the issuer of the certificate.  The value of this property is a comma separated key=value format.  Each key is one of the attribute names supported by X.500.")
    @JsonProperty(value="issuer")
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public CertificateDetails subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="Information about the subject of the certificate.  The value of this property is a comma separated key=value format.  Each key is one of the attribute names supported by X.500.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public CertificateDetails expirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The expiration date of the certificate. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="expirationDate")
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public CertificateDetails issueDate(Date issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    @ApiModelProperty(example="null", value="The issue date of the certificate. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="issueDate")
    public Date getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    public CertificateDetails expired(Boolean expired) {
        this.expired = expired;
        return this;
    }

    @ApiModelProperty(example="null", value="True if the certificate is expired, false otherwise.")
    @JsonProperty(value="expired")
    public Boolean getExpired() {
        return this.expired;
    }

    public void setExpired(Boolean expired) {
        this.expired = expired;
    }

    public CertificateDetails valid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="valid")
    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public CertificateDetails signatureValid(Boolean signatureValid) {
        this.signatureValid = signatureValid;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="signatureValid")
    public Boolean getSignatureValid() {
        return this.signatureValid;
    }

    public void setSignatureValid(Boolean signatureValid) {
        this.signatureValid = signatureValid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertificateDetails certificateDetails = (CertificateDetails)o;
        return Objects.equals(this.issuer, certificateDetails.issuer) && Objects.equals(this.subject, certificateDetails.subject) && Objects.equals(this.expirationDate, certificateDetails.expirationDate) && Objects.equals(this.issueDate, certificateDetails.issueDate) && Objects.equals(this.expired, certificateDetails.expired) && Objects.equals(this.valid, certificateDetails.valid) && Objects.equals(this.signatureValid, certificateDetails.signatureValid);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.subject, this.expirationDate, this.issueDate, this.expired, this.valid, this.signatureValid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CertificateDetails {\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    expirationDate: ").append(this.toIndentedString(this.expirationDate)).append("\n");
        sb.append("    issueDate: ").append(this.toIndentedString(this.issueDate)).append("\n");
        sb.append("    expired: ").append(this.toIndentedString(this.expired)).append("\n");
        sb.append("    valid: ").append(this.toIndentedString(this.valid)).append("\n");
        sb.append("    signatureValid: ").append(this.toIndentedString(this.signatureValid)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

