/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DurationCondition;
import com.mypurecloud.sdk.v2.model.Queue;
import com.mypurecloud.sdk.v2.model.TimeAllowed;
import com.mypurecloud.sdk.v2.model.User;
import com.mypurecloud.sdk.v2.model.WrapupCode;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PolicyConditions
implements Serializable {
    private List<User> forUsers = new ArrayList<User>();
    private List<DirectionsEnum> directions = new ArrayList<DirectionsEnum>();
    private List<String> dateRanges = new ArrayList<String>();
    private List<MediaTypesEnum> mediaTypes = new ArrayList<MediaTypesEnum>();
    private List<Queue> forQueues = new ArrayList<Queue>();
    private DurationCondition duration = null;
    private List<WrapupCode> wrapupCodes = new ArrayList<WrapupCode>();
    private TimeAllowed timeAllowed = null;
    private CustomerParticipationEnum customerParticipation = null;

    public PolicyConditions forUsers(List<User> forUsers) {
        this.forUsers = forUsers;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="forUsers")
    public List<User> getForUsers() {
        return this.forUsers;
    }

    public void setForUsers(List<User> forUsers) {
        this.forUsers = forUsers;
    }

    public PolicyConditions directions(List<DirectionsEnum> directions) {
        this.directions = directions;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="directions")
    public List<DirectionsEnum> getDirections() {
        return this.directions;
    }

    public void setDirections(List<DirectionsEnum> directions) {
        this.directions = directions;
    }

    public PolicyConditions dateRanges(List<String> dateRanges) {
        this.dateRanges = dateRanges;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="dateRanges")
    public List<String> getDateRanges() {
        return this.dateRanges;
    }

    public void setDateRanges(List<String> dateRanges) {
        this.dateRanges = dateRanges;
    }

    public PolicyConditions mediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="mediaTypes")
    public List<MediaTypesEnum> getMediaTypes() {
        return this.mediaTypes;
    }

    public void setMediaTypes(List<MediaTypesEnum> mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public PolicyConditions forQueues(List<Queue> forQueues) {
        this.forQueues = forQueues;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="forQueues")
    public List<Queue> getForQueues() {
        return this.forQueues;
    }

    public void setForQueues(List<Queue> forQueues) {
        this.forQueues = forQueues;
    }

    public PolicyConditions duration(DurationCondition duration) {
        this.duration = duration;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="duration")
    public DurationCondition getDuration() {
        return this.duration;
    }

    public void setDuration(DurationCondition duration) {
        this.duration = duration;
    }

    public PolicyConditions wrapupCodes(List<WrapupCode> wrapupCodes) {
        this.wrapupCodes = wrapupCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="wrapupCodes")
    public List<WrapupCode> getWrapupCodes() {
        return this.wrapupCodes;
    }

    public void setWrapupCodes(List<WrapupCode> wrapupCodes) {
        this.wrapupCodes = wrapupCodes;
    }

    public PolicyConditions timeAllowed(TimeAllowed timeAllowed) {
        this.timeAllowed = timeAllowed;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="timeAllowed")
    public TimeAllowed getTimeAllowed() {
        return this.timeAllowed;
    }

    public void setTimeAllowed(TimeAllowed timeAllowed) {
        this.timeAllowed = timeAllowed;
    }

    public PolicyConditions customerParticipation(CustomerParticipationEnum customerParticipation) {
        this.customerParticipation = customerParticipation;
        return this;
    }

    @ApiModelProperty(example="null", value="This condition is to filter out conversation with and without customer participation.")
    @JsonProperty(value="customerParticipation")
    public CustomerParticipationEnum getCustomerParticipation() {
        return this.customerParticipation;
    }

    public void setCustomerParticipation(CustomerParticipationEnum customerParticipation) {
        this.customerParticipation = customerParticipation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyConditions policyConditions = (PolicyConditions)o;
        return Objects.equals(this.forUsers, policyConditions.forUsers) && Objects.equals(this.directions, policyConditions.directions) && Objects.equals(this.dateRanges, policyConditions.dateRanges) && Objects.equals(this.mediaTypes, policyConditions.mediaTypes) && Objects.equals(this.forQueues, policyConditions.forQueues) && Objects.equals(this.duration, policyConditions.duration) && Objects.equals(this.wrapupCodes, policyConditions.wrapupCodes) && Objects.equals(this.timeAllowed, policyConditions.timeAllowed) && Objects.equals((Object)this.customerParticipation, (Object)policyConditions.customerParticipation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.forUsers, this.directions, this.dateRanges, this.mediaTypes, this.forQueues, this.duration, this.wrapupCodes, this.timeAllowed, this.customerParticipation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyConditions {\n");
        sb.append("    forUsers: ").append(this.toIndentedString(this.forUsers)).append("\n");
        sb.append("    directions: ").append(this.toIndentedString(this.directions)).append("\n");
        sb.append("    dateRanges: ").append(this.toIndentedString(this.dateRanges)).append("\n");
        sb.append("    mediaTypes: ").append(this.toIndentedString(this.mediaTypes)).append("\n");
        sb.append("    forQueues: ").append(this.toIndentedString(this.forQueues)).append("\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    wrapupCodes: ").append(this.toIndentedString(this.wrapupCodes)).append("\n");
        sb.append("    timeAllowed: ").append(this.toIndentedString(this.timeAllowed)).append("\n");
        sb.append("    customerParticipation: ").append(this.toIndentedString((Object)this.customerParticipation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CustomerParticipationEnumDeserializer.class)
    public static enum CustomerParticipationEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        YES("YES"),
        NO("NO");

        private String value;

        private CustomerParticipationEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CustomerParticipationEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CustomerParticipationEnum value : CustomerParticipationEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CustomerParticipationEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CustomerParticipationEnumDeserializer
    extends StdDeserializer<CustomerParticipationEnum> {
        public CustomerParticipationEnumDeserializer() {
            super(CustomerParticipationEnumDeserializer.class);
        }

        public CustomerParticipationEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CustomerParticipationEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MediaTypesEnumDeserializer.class)
    public static enum MediaTypesEnum {
        CALL("CALL"),
        CHAT("CHAT");

        private String value;

        private MediaTypesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MediaTypesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MediaTypesEnum value : MediaTypesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MediaTypesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MediaTypesEnumDeserializer
    extends StdDeserializer<MediaTypesEnum> {
        public MediaTypesEnumDeserializer() {
            super(MediaTypesEnumDeserializer.class);
        }

        public MediaTypesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MediaTypesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DirectionsEnumDeserializer.class)
    public static enum DirectionsEnum {
        INBOUND("INBOUND"),
        OUTBOUND("OUTBOUND");

        private String value;

        private DirectionsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionsEnum value : DirectionsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionsEnumDeserializer
    extends StdDeserializer<DirectionsEnum> {
        public DirectionsEnumDeserializer() {
            super(DirectionsEnumDeserializer.class);
        }

        public DirectionsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

