/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Metadata information about a message event.")
public class ConversationMessageMetadataEvent
implements Serializable {
    private EventTypeEnum eventType = null;
    private SubTypeEnum subType = null;

    public ConversationMessageMetadataEvent eventType(EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of this event element")
    @JsonProperty(value="eventType")
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public ConversationMessageMetadataEvent subType(SubTypeEnum subType) {
        this.subType = subType;
        return this;
    }

    @ApiModelProperty(example="null", value="Event subtype")
    @JsonProperty(value="subType")
    public SubTypeEnum getSubType() {
        return this.subType;
    }

    public void setSubType(SubTypeEnum subType) {
        this.subType = subType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationMessageMetadataEvent conversationMessageMetadataEvent = (ConversationMessageMetadataEvent)o;
        return Objects.equals((Object)this.eventType, (Object)conversationMessageMetadataEvent.eventType) && Objects.equals((Object)this.subType, (Object)conversationMessageMetadataEvent.subType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventType, this.subType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationMessageMetadataEvent {\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    subType: ").append(this.toIndentedString((Object)this.subType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=SubTypeEnumDeserializer.class)
    public static enum SubTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ON("On"),
        JOIN("Join"),
        OFFERING("Offering"),
        OFFERINGEXPIRED("OfferingExpired"),
        OFFERINGACCEPTED("OfferingAccepted"),
        OFFERINGREJECTED("OfferingRejected"),
        DISCONNECT("Disconnect"),
        UNKNOWN("Unknown");

        private String value;

        private SubTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static SubTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (SubTypeEnum value : SubTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return SubTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class SubTypeEnumDeserializer
    extends StdDeserializer<SubTypeEnum> {
        public SubTypeEnumDeserializer() {
            super(SubTypeEnumDeserializer.class);
        }

        public SubTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return SubTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=EventTypeEnumDeserializer.class)
    public static enum EventTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        COBROWSE("CoBrowse"),
        TYPING("Typing"),
        PRESENCE("Presence"),
        UNKNOWN("Unknown");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EventTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EventTypeEnum value : EventTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EventTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EventTypeEnumDeserializer
    extends StdDeserializer<EventTypeEnum> {
        public EventTypeEnumDeserializer() {
            super(EventTypeEnumDeserializer.class);
        }

        public EventTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EventTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

