/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.util.HashMap;
import java.util.Map;

public class GetOauthScopesRequest {
    private String acceptLanguage;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAcceptLanguage() {
        return this.acceptLanguage;
    }

    public void setAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
    }

    public GetOauthScopesRequest withAcceptLanguage(String acceptLanguage) {
        this.setAcceptLanguage(acceptLanguage);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetOauthScopesRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        return ApiRequestBuilder.create("GET", "/api/v2/oauth/scopes").withHeaderParameter("Accept-Language", this.acceptLanguage).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final GetOauthScopesRequest request = new GetOauthScopesRequest();

        private Builder() {
        }

        public Builder withAcceptLanguage(String acceptLanguage) {
            this.request.setAcceptLanguage(acceptLanguage);
            return this;
        }

        public GetOauthScopesRequest build() {
            return this.request;
        }
    }
}

