/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.ContentActions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="An entry in a List template.")
public class ListItemComponent
implements Serializable {
    private String id = null;
    private String rmid = null;
    private TypeEnum type = null;
    private String image = null;
    private String title = null;
    private String description = null;
    private ContentActions actions = null;

    public ListItemComponent id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID assigned to this list item.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ListItemComponent rmid(String rmid) {
        this.rmid = rmid;
        return this;
    }

    @ApiModelProperty(example="null", value="An ID of the rich message instance.")
    @JsonProperty(value="rmid")
    public String getRmid() {
        return this.rmid;
    }

    public void setRmid(String rmid) {
        this.rmid = rmid;
    }

    public ListItemComponent type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", value="The type of list item to render.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ListItemComponent image(String image) {
        this.image = image;
        return this;
    }

    @ApiModelProperty(example="null", value="URL of an image.")
    @JsonProperty(value="image")
    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public ListItemComponent title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(example="null", value="The main headline of the list item.")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ListItemComponent description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="null", value="Text to show in the list item description.")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ListItemComponent actions(ContentActions actions) {
        this.actions = actions;
        return this;
    }

    @ApiModelProperty(example="null", value="The list item actions (Deprecated).")
    @JsonProperty(value="actions")
    public ContentActions getActions() {
        return this.actions;
    }

    public void setActions(ContentActions actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListItemComponent listItemComponent = (ListItemComponent)o;
        return Objects.equals(this.id, listItemComponent.id) && Objects.equals(this.rmid, listItemComponent.rmid) && Objects.equals((Object)this.type, (Object)listItemComponent.type) && Objects.equals(this.image, listItemComponent.image) && Objects.equals(this.title, listItemComponent.title) && Objects.equals(this.description, listItemComponent.description) && Objects.equals(this.actions, listItemComponent.actions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.rmid, this.type, this.image, this.title, this.description, this.actions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListItemComponent {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    rmid: ").append(this.toIndentedString(this.rmid)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LISTITEM("ListItem"),
        LISTITEMBIG("ListItemBig");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

