/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ImportStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class DncList
implements Serializable {
    private String id = null;
    private String name = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private Integer version = null;
    private ImportStatus importStatus = null;
    private Long size = null;
    private DncSourceTypeEnum dncSourceType = null;
    private ContactMethodEnum contactMethod = null;
    private String loginId = null;
    private String campaignId = null;
    private List<String> dncCodes = new ArrayList<String>();
    private String licenseId = null;
    private DomainEntityRef division = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DncList name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the DncList.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(example="null", value="Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    @ApiModelProperty(example="null", value="Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public DncList version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", value="Required for updates, must match the version number of the most recent update")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The status of the import process")
    @JsonProperty(value="importStatus")
    public ImportStatus getImportStatus() {
        return this.importStatus;
    }

    @ApiModelProperty(example="null", value="The total number of phone numbers in the DncList.")
    @JsonProperty(value="size")
    public Long getSize() {
        return this.size;
    }

    @ApiModelProperty(example="null", required=true, value="The type of the DncList.")
    @JsonProperty(value="dncSourceType")
    public DncSourceTypeEnum getDncSourceType() {
        return this.dncSourceType;
    }

    public DncList contactMethod(ContactMethodEnum contactMethod) {
        this.contactMethod = contactMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="The contact method. Required if dncSourceType is rds.")
    @JsonProperty(value="contactMethod")
    public ContactMethodEnum getContactMethod() {
        return this.contactMethod;
    }

    public void setContactMethod(ContactMethodEnum contactMethod) {
        this.contactMethod = contactMethod;
    }

    public DncList loginId(String loginId) {
        this.loginId = loginId;
        return this;
    }

    @ApiModelProperty(example="null", value="A dnc.com loginId. Required if the dncSourceType is dnc.com.")
    @JsonProperty(value="loginId")
    public String getLoginId() {
        return this.loginId;
    }

    public void setLoginId(String loginId) {
        this.loginId = loginId;
    }

    public DncList campaignId(String campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    @ApiModelProperty(example="null", value="A dnc.com campaignId. Optional if the dncSourceType is dnc.com.")
    @JsonProperty(value="campaignId")
    public String getCampaignId() {
        return this.campaignId;
    }

    public void setCampaignId(String campaignId) {
        this.campaignId = campaignId;
    }

    public DncList dncCodes(List<String> dncCodes) {
        this.dncCodes = dncCodes;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of dnc.com codes to be treated as DNC. Required if the dncSourceType is dnc.com.")
    @JsonProperty(value="dncCodes")
    public List<String> getDncCodes() {
        return this.dncCodes;
    }

    public void setDncCodes(List<String> dncCodes) {
        this.dncCodes = dncCodes;
    }

    public DncList licenseId(String licenseId) {
        this.licenseId = licenseId;
        return this;
    }

    @ApiModelProperty(example="null", value="A gryphon license number. Required if the dncSourceType is gryphon.")
    @JsonProperty(value="licenseId")
    public String getLicenseId() {
        return this.licenseId;
    }

    public void setLicenseId(String licenseId) {
        this.licenseId = licenseId;
    }

    public DncList division(DomainEntityRef division) {
        this.division = division;
        return this;
    }

    @ApiModelProperty(example="null", value="The division this DncList belongs to.")
    @JsonProperty(value="division")
    public DomainEntityRef getDivision() {
        return this.division;
    }

    public void setDivision(DomainEntityRef division) {
        this.division = division;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DncList dncList = (DncList)o;
        return Objects.equals(this.id, dncList.id) && Objects.equals(this.name, dncList.name) && Objects.equals(this.dateCreated, dncList.dateCreated) && Objects.equals(this.dateModified, dncList.dateModified) && Objects.equals(this.version, dncList.version) && Objects.equals(this.importStatus, dncList.importStatus) && Objects.equals(this.size, dncList.size) && Objects.equals((Object)this.dncSourceType, (Object)dncList.dncSourceType) && Objects.equals((Object)this.contactMethod, (Object)dncList.contactMethod) && Objects.equals(this.loginId, dncList.loginId) && Objects.equals(this.campaignId, dncList.campaignId) && Objects.equals(this.dncCodes, dncList.dncCodes) && Objects.equals(this.licenseId, dncList.licenseId) && Objects.equals(this.division, dncList.division) && Objects.equals(this.selfUri, dncList.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.dateCreated, this.dateModified, this.version, this.importStatus, this.size, this.dncSourceType, this.contactMethod, this.loginId, this.campaignId, this.dncCodes, this.licenseId, this.division, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DncList {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    importStatus: ").append(this.toIndentedString(this.importStatus)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    dncSourceType: ").append(this.toIndentedString((Object)this.dncSourceType)).append("\n");
        sb.append("    contactMethod: ").append(this.toIndentedString((Object)this.contactMethod)).append("\n");
        sb.append("    loginId: ").append(this.toIndentedString(this.loginId)).append("\n");
        sb.append("    campaignId: ").append(this.toIndentedString(this.campaignId)).append("\n");
        sb.append("    dncCodes: ").append(this.toIndentedString(this.dncCodes)).append("\n");
        sb.append("    licenseId: ").append(this.toIndentedString(this.licenseId)).append("\n");
        sb.append("    division: ").append(this.toIndentedString(this.division)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ContactMethodEnumDeserializer.class)
    public static enum ContactMethodEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EMAIL("Email"),
        PHONE("Phone"),
        ANY("Any");

        private String value;

        private ContactMethodEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ContactMethodEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ContactMethodEnum value : ContactMethodEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ContactMethodEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ContactMethodEnumDeserializer
    extends StdDeserializer<ContactMethodEnum> {
        public ContactMethodEnumDeserializer() {
            super(ContactMethodEnumDeserializer.class);
        }

        public ContactMethodEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ContactMethodEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=DncSourceTypeEnumDeserializer.class)
    public static enum DncSourceTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        RDS("rds"),
        RDS_CUSTOM("rds_custom"),
        DNC_COM("dnc.com"),
        GRYPHON("gryphon");

        private String value;

        private DncSourceTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DncSourceTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DncSourceTypeEnum value : DncSourceTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DncSourceTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DncSourceTypeEnumDeserializer
    extends StdDeserializer<DncSourceTypeEnum> {
        public DncSourceTypeEnumDeserializer() {
            super(DncSourceTypeEnumDeserializer.class);
        }

        public DncSourceTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DncSourceTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

