/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class ColumnDataTypeSpecification
implements Serializable {
    private String columnName = null;
    private ColumnDataTypeEnum columnDataType = null;
    private Integer min = null;
    private Integer max = null;
    private Integer maxLength = null;

    public ColumnDataTypeSpecification columnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    @ApiModelProperty(example="null", value="The column name of a column selected for dynamic queueing")
    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public ColumnDataTypeSpecification columnDataType(ColumnDataTypeEnum columnDataType) {
        this.columnDataType = columnDataType;
        return this;
    }

    @ApiModelProperty(example="null", value="The data type of the column selected for dynamic queueing (TEXT, NUMERIC or TIMESTAMP)")
    @JsonProperty(value="columnDataType")
    public ColumnDataTypeEnum getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(ColumnDataTypeEnum columnDataType) {
        this.columnDataType = columnDataType;
    }

    public ColumnDataTypeSpecification min(Integer min) {
        this.min = min;
        return this;
    }

    @ApiModelProperty(example="null", value="The minimum length of the numeric column selected for dynamic queueing")
    @JsonProperty(value="min")
    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public ColumnDataTypeSpecification max(Integer max) {
        this.max = max;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum length of the numeric column selected for dynamic queueing")
    @JsonProperty(value="max")
    public Integer getMax() {
        return this.max;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public ColumnDataTypeSpecification maxLength(Integer maxLength) {
        this.maxLength = maxLength;
        return this;
    }

    @ApiModelProperty(example="null", value="The maximum length of the text column selected for dynamic queueing")
    @JsonProperty(value="maxLength")
    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnDataTypeSpecification columnDataTypeSpecification = (ColumnDataTypeSpecification)o;
        return Objects.equals(this.columnName, columnDataTypeSpecification.columnName) && Objects.equals((Object)this.columnDataType, (Object)columnDataTypeSpecification.columnDataType) && Objects.equals(this.min, columnDataTypeSpecification.min) && Objects.equals(this.max, columnDataTypeSpecification.max) && Objects.equals(this.maxLength, columnDataTypeSpecification.maxLength);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.columnDataType, this.min, this.max, this.maxLength});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ColumnDataTypeSpecification {\n");
        sb.append("    columnName: ").append(this.toIndentedString(this.columnName)).append("\n");
        sb.append("    columnDataType: ").append(this.toIndentedString((Object)this.columnDataType)).append("\n");
        sb.append("    min: ").append(this.toIndentedString(this.min)).append("\n");
        sb.append("    max: ").append(this.toIndentedString(this.max)).append("\n");
        sb.append("    maxLength: ").append(this.toIndentedString(this.maxLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ColumnDataTypeEnumDeserializer.class)
    public static enum ColumnDataTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        NUMERIC("NUMERIC"),
        TEXT("TEXT"),
        TIMESTAMP("TIMESTAMP");

        private String value;

        private ColumnDataTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ColumnDataTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ColumnDataTypeEnum value : ColumnDataTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ColumnDataTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ColumnDataTypeEnumDeserializer
    extends StdDeserializer<ColumnDataTypeEnum> {
        public ColumnDataTypeEnumDeserializer() {
            super(ColumnDataTypeEnumDeserializer.class);
        }

        public ColumnDataTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ColumnDataTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

