/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.ScimV2PatchRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchScimV2UserRequest {
    private String userId;
    private ScimV2PatchRequest body;
    private String ifMatch;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public PatchScimV2UserRequest withUserId(String userId) {
        this.setUserId(userId);
        return this;
    }

    public ScimV2PatchRequest getBody() {
        return this.body;
    }

    public void setBody(ScimV2PatchRequest body) {
        this.body = body;
    }

    public PatchScimV2UserRequest withBody(ScimV2PatchRequest body) {
        this.setBody(body);
        return this;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public void setIfMatch(String ifMatch) {
        this.ifMatch = ifMatch;
    }

    public PatchScimV2UserRequest withIfMatch(String ifMatch) {
        this.setIfMatch(ifMatch);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchScimV2UserRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<ScimV2PatchRequest> withHttpInfo() {
        if (this.userId == null) {
            throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchScimV2UserRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimV2UserRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/scim/v2/users/{userId}").withPathParameter("userId", this.userId).withHeaderParameter("If-Match", this.ifMatch).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/scim+json", "application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String userId, ScimV2PatchRequest body) {
        return new Builder().withRequiredParams(userId, body);
    }

    public static class Builder {
        private final PatchScimV2UserRequest request = new PatchScimV2UserRequest();

        private Builder() {
        }

        public Builder withUserId(String userId) {
            this.request.setUserId(userId);
            return this;
        }

        public Builder withBody(ScimV2PatchRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withIfMatch(String ifMatch) {
            this.request.setIfMatch(ifMatch);
            return this;
        }

        public Builder withRequiredParams(String userId, ScimV2PatchRequest body) {
            this.request.setUserId(userId);
            this.request.setBody(body);
            return this;
        }

        public PatchScimV2UserRequest build() {
            if (this.request.userId == null) {
                throw new IllegalStateException("Missing the required parameter 'userId' when building request for PatchScimV2UserRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchScimV2UserRequest.");
            }
            return this.request;
        }
    }
}

