/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class DigitalDataActionConditionPredicate
implements Serializable {
    private String outputField = null;
    private OutputOperatorEnum outputOperator = null;
    private String comparisonValue = null;
    private Boolean inverted = null;
    private Boolean outputFieldMissingResolution = null;
    private ValueTypeEnum valueType = null;

    public DigitalDataActionConditionPredicate outputField(String outputField) {
        this.outputField = outputField;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of an output field from the data action's output to use for this condition")
    @JsonProperty(value="outputField")
    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public DigitalDataActionConditionPredicate outputOperator(OutputOperatorEnum outputOperator) {
        this.outputOperator = outputOperator;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The operation with which to evaluate this condition")
    @JsonProperty(value="outputOperator")
    public OutputOperatorEnum getOutputOperator() {
        return this.outputOperator;
    }

    public void setOutputOperator(OutputOperatorEnum outputOperator) {
        this.outputOperator = outputOperator;
    }

    public DigitalDataActionConditionPredicate comparisonValue(String comparisonValue) {
        this.comparisonValue = comparisonValue;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The value to compare against for this condition")
    @JsonProperty(value="comparisonValue")
    public String getComparisonValue() {
        return this.comparisonValue;
    }

    public void setComparisonValue(String comparisonValue) {
        this.comparisonValue = comparisonValue;
    }

    public DigitalDataActionConditionPredicate inverted(Boolean inverted) {
        this.inverted = inverted;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="If true, inverts the result of evaluating this Predicate. Default is false.")
    @JsonProperty(value="inverted")
    public Boolean getInverted() {
        return this.inverted;
    }

    public void setInverted(Boolean inverted) {
        this.inverted = inverted;
    }

    public DigitalDataActionConditionPredicate outputFieldMissingResolution(Boolean outputFieldMissingResolution) {
        this.outputFieldMissingResolution = outputFieldMissingResolution;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The result of this predicate if the requested output field is missing from the data action's result")
    @JsonProperty(value="outputFieldMissingResolution")
    public Boolean getOutputFieldMissingResolution() {
        return this.outputFieldMissingResolution;
    }

    public void setOutputFieldMissingResolution(Boolean outputFieldMissingResolution) {
        this.outputFieldMissingResolution = outputFieldMissingResolution;
    }

    public DigitalDataActionConditionPredicate valueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The data type the value should be treated as.")
    @JsonProperty(value="valueType")
    public ValueTypeEnum getValueType() {
        return this.valueType;
    }

    public void setValueType(ValueTypeEnum valueType) {
        this.valueType = valueType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DigitalDataActionConditionPredicate digitalDataActionConditionPredicate = (DigitalDataActionConditionPredicate)o;
        return Objects.equals(this.outputField, digitalDataActionConditionPredicate.outputField) && Objects.equals((Object)this.outputOperator, (Object)digitalDataActionConditionPredicate.outputOperator) && Objects.equals(this.comparisonValue, digitalDataActionConditionPredicate.comparisonValue) && Objects.equals(this.inverted, digitalDataActionConditionPredicate.inverted) && Objects.equals(this.outputFieldMissingResolution, digitalDataActionConditionPredicate.outputFieldMissingResolution) && Objects.equals((Object)this.valueType, (Object)digitalDataActionConditionPredicate.valueType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.outputField, this.outputOperator, this.comparisonValue, this.inverted, this.outputFieldMissingResolution, this.valueType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DigitalDataActionConditionPredicate {\n");
        sb.append("    outputField: ").append(this.toIndentedString(this.outputField)).append("\n");
        sb.append("    outputOperator: ").append(this.toIndentedString((Object)this.outputOperator)).append("\n");
        sb.append("    comparisonValue: ").append(this.toIndentedString(this.comparisonValue)).append("\n");
        sb.append("    inverted: ").append(this.toIndentedString(this.inverted)).append("\n");
        sb.append("    outputFieldMissingResolution: ").append(this.toIndentedString(this.outputFieldMissingResolution)).append("\n");
        sb.append("    valueType: ").append(this.toIndentedString((Object)this.valueType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ValueTypeEnumDeserializer.class)
    public static enum ValueTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        DATETIME("DateTime"),
        NUMERIC("Numeric"),
        PERIOD("Period"),
        STRING("String");

        private String value;

        private ValueTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ValueTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ValueTypeEnum value : ValueTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ValueTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ValueTypeEnumDeserializer
    extends StdDeserializer<ValueTypeEnum> {
        public ValueTypeEnumDeserializer() {
            super(ValueTypeEnumDeserializer.class);
        }

        public ValueTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ValueTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=OutputOperatorEnumDeserializer.class)
    public static enum OutputOperatorEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        EQUALS("Equals"),
        LESSTHAN("LessThan"),
        LESSTHANEQUALS("LessThanEquals"),
        GREATERTHAN("GreaterThan"),
        GREATERTHANEQUALS("GreaterThanEquals"),
        CONTAINS("Contains"),
        BEGINSWITH("BeginsWith"),
        ENDSWITH("EndsWith"),
        BEFORE("Before"),
        AFTER("After");

        private String value;

        private OutputOperatorEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static OutputOperatorEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (OutputOperatorEnum value : OutputOperatorEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return OutputOperatorEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class OutputOperatorEnumDeserializer
    extends StdDeserializer<OutputOperatorEnum> {
        public OutputOperatorEnumDeserializer() {
            super(OutputOperatorEnumDeserializer.class);
        }

        public OutputOperatorEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return OutputOperatorEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

