/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.CallRecord;
import com.mypurecloud.sdk.v2.model.ConfigurationOverrides;
import com.mypurecloud.sdk.v2.model.ContactColumnTimeZone;
import com.mypurecloud.sdk.v2.model.ContactableStatus;
import com.mypurecloud.sdk.v2.model.MessageEvaluation;
import com.mypurecloud.sdk.v2.model.PhoneNumberStatus;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

public class DialerContact
implements Serializable {
    private String id = null;
    private String name = null;
    private String contactListId = null;
    private Map<String, Object> data = null;
    private Map<String, CallRecord> callRecords = null;
    private Map<String, MessageEvaluation> latestSmsEvaluations = null;
    private Boolean callable = null;
    private Map<String, PhoneNumberStatus> phoneNumberStatus = null;
    private Map<String, ContactableStatus> contactableStatus = null;
    private Map<String, ContactColumnTimeZone> contactColumnTimeZones = null;
    private ConfigurationOverrides configurationOverrides = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public DialerContact name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DialerContact contactListId(String contactListId) {
        this.contactListId = contactListId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The identifier of the contact list containing this contact.")
    @JsonProperty(value="contactListId")
    public String getContactListId() {
        return this.contactListId;
    }

    public void setContactListId(String contactListId) {
        this.contactListId = contactListId;
    }

    public DialerContact data(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="An ordered map of the contact's columns and corresponding values.")
    @JsonProperty(value="data")
    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @ApiModelProperty(example="null", value="A map of call records for the contact phone columns.")
    @JsonProperty(value="callRecords")
    public Map<String, CallRecord> getCallRecords() {
        return this.callRecords;
    }

    @ApiModelProperty(example="null", value="A map of SMS records for the contact phone columns.")
    @JsonProperty(value="latestSmsEvaluations")
    public Map<String, MessageEvaluation> getLatestSmsEvaluations() {
        return this.latestSmsEvaluations;
    }

    public DialerContact callable(Boolean callable) {
        this.callable = callable;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether or not the contact can be called.")
    @JsonProperty(value="callable")
    public Boolean getCallable() {
        return this.callable;
    }

    public void setCallable(Boolean callable) {
        this.callable = callable;
    }

    public DialerContact phoneNumberStatus(Map<String, PhoneNumberStatus> phoneNumberStatus) {
        this.phoneNumberStatus = phoneNumberStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="A map of phone number columns to PhoneNumberStatuses, which indicate if the phone number is callable or not.")
    @JsonProperty(value="phoneNumberStatus")
    public Map<String, PhoneNumberStatus> getPhoneNumberStatus() {
        return this.phoneNumberStatus;
    }

    public void setPhoneNumberStatus(Map<String, PhoneNumberStatus> phoneNumberStatus) {
        this.phoneNumberStatus = phoneNumberStatus;
    }

    public DialerContact contactableStatus(Map<String, ContactableStatus> contactableStatus) {
        this.contactableStatus = contactableStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="A map of media types (Voice, SMS and Email) to ContactableStatus, which indicates if the contact can be contacted using the specified media type.")
    @JsonProperty(value="contactableStatus")
    public Map<String, ContactableStatus> getContactableStatus() {
        return this.contactableStatus;
    }

    public void setContactableStatus(Map<String, ContactableStatus> contactableStatus) {
        this.contactableStatus = contactableStatus;
    }

    @ApiModelProperty(example="null", value="Map containing data about the timezone the contact is mapped to. This will only be populated if the contact list has automatic timezone mapping turned on. The key is the column name. The value is the timezone it mapped to and the type of column: Phone or Zip")
    @JsonProperty(value="contactColumnTimeZones")
    public Map<String, ContactColumnTimeZone> getContactColumnTimeZones() {
        return this.contactColumnTimeZones;
    }

    @ApiModelProperty(example="null", value="the priority property within ConfigurationOverides indicates whether or not the contact to be placed in front of the queue or at the end of the queue")
    @JsonProperty(value="configurationOverrides")
    public ConfigurationOverrides getConfigurationOverrides() {
        return this.configurationOverrides;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DialerContact dialerContact = (DialerContact)o;
        return Objects.equals(this.id, dialerContact.id) && Objects.equals(this.name, dialerContact.name) && Objects.equals(this.contactListId, dialerContact.contactListId) && Objects.equals(this.data, dialerContact.data) && Objects.equals(this.callRecords, dialerContact.callRecords) && Objects.equals(this.latestSmsEvaluations, dialerContact.latestSmsEvaluations) && Objects.equals(this.callable, dialerContact.callable) && Objects.equals(this.phoneNumberStatus, dialerContact.phoneNumberStatus) && Objects.equals(this.contactableStatus, dialerContact.contactableStatus) && Objects.equals(this.contactColumnTimeZones, dialerContact.contactColumnTimeZones) && Objects.equals(this.configurationOverrides, dialerContact.configurationOverrides) && Objects.equals(this.selfUri, dialerContact.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.contactListId, this.data, this.callRecords, this.latestSmsEvaluations, this.callable, this.phoneNumberStatus, this.contactableStatus, this.contactColumnTimeZones, this.configurationOverrides, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DialerContact {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    contactListId: ").append(this.toIndentedString(this.contactListId)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    callRecords: ").append(this.toIndentedString(this.callRecords)).append("\n");
        sb.append("    latestSmsEvaluations: ").append(this.toIndentedString(this.latestSmsEvaluations)).append("\n");
        sb.append("    callable: ").append(this.toIndentedString(this.callable)).append("\n");
        sb.append("    phoneNumberStatus: ").append(this.toIndentedString(this.phoneNumberStatus)).append("\n");
        sb.append("    contactableStatus: ").append(this.toIndentedString(this.contactableStatus)).append("\n");
        sb.append("    contactColumnTimeZones: ").append(this.toIndentedString(this.contactColumnTimeZones)).append("\n");
        sb.append("    configurationOverrides: ").append(this.toIndentedString(this.configurationOverrides)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

