/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.Attachment;
import com.mypurecloud.sdk.v2.model.EmailAddress;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class EmailMessage
implements Serializable {
    private String id = null;
    private String name = null;
    private List<EmailAddress> to = new ArrayList<EmailAddress>();
    private List<EmailAddress> cc = new ArrayList<EmailAddress>();
    private List<EmailAddress> bcc = new ArrayList<EmailAddress>();
    private EmailAddress from = null;
    private String subject = null;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private String textBody = null;
    private String htmlBody = null;
    private Date time = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public EmailMessage name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EmailMessage to(List<EmailAddress> to) {
        this.to = to;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipients of the email message.")
    @JsonProperty(value="to")
    public List<EmailAddress> getTo() {
        return this.to;
    }

    public void setTo(List<EmailAddress> to) {
        this.to = to;
    }

    public EmailMessage cc(List<EmailAddress> cc) {
        this.cc = cc;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipients that were copied on the email message.")
    @JsonProperty(value="cc")
    public List<EmailAddress> getCc() {
        return this.cc;
    }

    public void setCc(List<EmailAddress> cc) {
        this.cc = cc;
    }

    public EmailMessage bcc(List<EmailAddress> bcc) {
        this.bcc = bcc;
        return this;
    }

    @ApiModelProperty(example="null", value="The recipients that were blind copied on the email message.")
    @JsonProperty(value="bcc")
    public List<EmailAddress> getBcc() {
        return this.bcc;
    }

    public void setBcc(List<EmailAddress> bcc) {
        this.bcc = bcc;
    }

    public EmailMessage from(EmailAddress from) {
        this.from = from;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The sender of the email message.")
    @JsonProperty(value="from")
    public EmailAddress getFrom() {
        return this.from;
    }

    public void setFrom(EmailAddress from) {
        this.from = from;
    }

    public EmailMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    @ApiModelProperty(example="null", value="The subject of the email message.")
    @JsonProperty(value="subject")
    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public EmailMessage attachments(List<Attachment> attachments) {
        this.attachments = attachments;
        return this;
    }

    @ApiModelProperty(example="null", value="The attachments of the email message.")
    @JsonProperty(value="attachments")
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public EmailMessage textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The text body of the email message.")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public EmailMessage htmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
        return this;
    }

    @ApiModelProperty(example="null", value="The html body of the email message.")
    @JsonProperty(value="htmlBody")
    public String getHtmlBody() {
        return this.htmlBody;
    }

    public void setHtmlBody(String htmlBody) {
        this.htmlBody = htmlBody;
    }

    public EmailMessage time(Date time) {
        this.time = time;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was received or sent. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ")
    @JsonProperty(value="time")
    public Date getTime() {
        return this.time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailMessage emailMessage = (EmailMessage)o;
        return Objects.equals(this.id, emailMessage.id) && Objects.equals(this.name, emailMessage.name) && Objects.equals(this.to, emailMessage.to) && Objects.equals(this.cc, emailMessage.cc) && Objects.equals(this.bcc, emailMessage.bcc) && Objects.equals(this.from, emailMessage.from) && Objects.equals(this.subject, emailMessage.subject) && Objects.equals(this.attachments, emailMessage.attachments) && Objects.equals(this.textBody, emailMessage.textBody) && Objects.equals(this.htmlBody, emailMessage.htmlBody) && Objects.equals(this.time, emailMessage.time) && Objects.equals(this.selfUri, emailMessage.selfUri);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.to, this.cc, this.bcc, this.from, this.subject, this.attachments, this.textBody, this.htmlBody, this.time, this.selfUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmailMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    to: ").append(this.toIndentedString(this.to)).append("\n");
        sb.append("    cc: ").append(this.toIndentedString(this.cc)).append("\n");
        sb.append("    bcc: ").append(this.toIndentedString(this.bcc)).append("\n");
        sb.append("    from: ").append(this.toIndentedString(this.from)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    attachments: ").append(this.toIndentedString(this.attachments)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    htmlBody: ").append(this.toIndentedString(this.htmlBody)).append("\n");
        sb.append("    time: ").append(this.toIndentedString(this.time)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

