/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

public class KnowledgeDocumentSearchRequest
implements Serializable {
    private String query = null;
    private Integer pageSize = null;
    private Integer pageNumber = null;
    private String searchId = null;
    private Integer total = null;
    private Integer pageCount = null;
    private Boolean includeDraftDocuments = null;

    public KnowledgeDocumentSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Query to search content in the knowledge base. Maximum of 30 records per query can be fetched.")
    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public KnowledgeDocumentSearchRequest pageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    @ApiModelProperty(example="null", value="Page size of the returned results.")
    @JsonProperty(value="pageSize")
    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public KnowledgeDocumentSearchRequest pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @ApiModelProperty(example="null", value="Page number of the returned results.")
    @JsonProperty(value="pageNumber")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @ApiModelProperty(example="null", value="The globally unique identifier for the search.")
    @JsonProperty(value="searchId")
    public String getSearchId() {
        return this.searchId;
    }

    @ApiModelProperty(example="null", value="The total number of documents matching the query.")
    @JsonProperty(value="total")
    public Integer getTotal() {
        return this.total;
    }

    @ApiModelProperty(example="null", value="Number of pages returned in the result calculated according to the pageSize and the total")
    @JsonProperty(value="pageCount")
    public Integer getPageCount() {
        return this.pageCount;
    }

    public KnowledgeDocumentSearchRequest includeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates whether the search results would also include draft documents.")
    @JsonProperty(value="includeDraftDocuments")
    public Boolean getIncludeDraftDocuments() {
        return this.includeDraftDocuments;
    }

    public void setIncludeDraftDocuments(Boolean includeDraftDocuments) {
        this.includeDraftDocuments = includeDraftDocuments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeDocumentSearchRequest knowledgeDocumentSearchRequest = (KnowledgeDocumentSearchRequest)o;
        return Objects.equals(this.query, knowledgeDocumentSearchRequest.query) && Objects.equals(this.pageSize, knowledgeDocumentSearchRequest.pageSize) && Objects.equals(this.pageNumber, knowledgeDocumentSearchRequest.pageNumber) && Objects.equals(this.searchId, knowledgeDocumentSearchRequest.searchId) && Objects.equals(this.total, knowledgeDocumentSearchRequest.total) && Objects.equals(this.pageCount, knowledgeDocumentSearchRequest.pageCount) && Objects.equals(this.includeDraftDocuments, knowledgeDocumentSearchRequest.includeDraftDocuments);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.pageSize, this.pageNumber, this.searchId, this.total, this.pageCount, this.includeDraftDocuments);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeDocumentSearchRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    pageSize: ").append(this.toIndentedString(this.pageSize)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("    searchId: ").append(this.toIndentedString(this.searchId)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("    pageCount: ").append(this.toIndentedString(this.pageCount)).append("\n");
        sb.append("    includeDraftDocuments: ").append(this.toIndentedString(this.includeDraftDocuments)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

