/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.ErrorBody;
import com.mypurecloud.sdk.v2.model.MessagingSettingReference;
import com.mypurecloud.sdk.v2.model.SupportedContentReference;
import com.mypurecloud.sdk.v2.model.WhatsAppAvailablePhoneNumberDetailsListing;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class WhatsAppIntegration
implements Serializable {
    private String id = null;
    private String name = null;
    private SupportedContentReference supportedContent = null;
    private MessagingSettingReference messagingSetting = null;
    private String phoneNumber = null;
    private WhatsAppAvailablePhoneNumberDetailsListing availablePhoneNumbers = null;
    private StatusEnum status = null;
    private DomainEntityRef recipient = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private DomainEntityRef createdBy = null;
    private DomainEntityRef modifiedBy = null;
    private Integer version = null;
    private ActivationStatusCodeEnum activationStatusCode = null;
    private ErrorBody activationErrorInfo = null;
    private CreateStatusEnum createStatus = null;
    private ErrorBody createError = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", required=true, value="A unique Integration Id.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public WhatsAppIntegration name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The name of the WhatsApp integration.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WhatsAppIntegration supportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
        return this;
    }

    @ApiModelProperty(example="null", value="Defines the SupportedContent profile configured for an integration")
    @JsonProperty(value="supportedContent")
    public SupportedContentReference getSupportedContent() {
        return this.supportedContent;
    }

    public void setSupportedContent(SupportedContentReference supportedContent) {
        this.supportedContent = supportedContent;
    }

    public WhatsAppIntegration messagingSetting(MessagingSettingReference messagingSetting) {
        this.messagingSetting = messagingSetting;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="messagingSetting")
    public MessagingSettingReference getMessagingSetting() {
        return this.messagingSetting;
    }

    public void setMessagingSetting(MessagingSettingReference messagingSetting) {
        this.messagingSetting = messagingSetting;
    }

    public WhatsAppIntegration phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The phone number associated to the WhatsApp integration.")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @ApiModelProperty(example="null", value="The list of available WhatsApp phone numbers for this account. Please select one phone number from this list to use with the created integration.")
    @JsonProperty(value="availablePhoneNumbers")
    public WhatsAppAvailablePhoneNumberDetailsListing getAvailablePhoneNumbers() {
        return this.availablePhoneNumbers;
    }

    public WhatsAppIntegration status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="The status of the WhatsApp Integration")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    @ApiModelProperty(example="null", value="The recipient associated to the WhatsApp Integration. This recipient is used to associate a flow to an integration")
    @JsonProperty(value="recipient")
    public DomainEntityRef getRecipient() {
        return this.recipient;
    }

    public WhatsAppIntegration dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public WhatsAppIntegration dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this Integration was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public WhatsAppIntegration createdBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that created this Integration")
    @JsonProperty(value="createdBy")
    public DomainEntityRef getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(DomainEntityRef createdBy) {
        this.createdBy = createdBy;
    }

    public WhatsAppIntegration modifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User reference that last modified this Integration")
    @JsonProperty(value="modifiedBy")
    public DomainEntityRef getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(DomainEntityRef modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public WhatsAppIntegration version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @ApiModelProperty(example="null", value="The status code of WhatsApp Integration activation process")
    @JsonProperty(value="activationStatusCode")
    public ActivationStatusCodeEnum getActivationStatusCode() {
        return this.activationStatusCode;
    }

    @ApiModelProperty(example="null", value="The error information of WhatsApp Integration activation process")
    @JsonProperty(value="activationErrorInfo")
    public ErrorBody getActivationErrorInfo() {
        return this.activationErrorInfo;
    }

    @ApiModelProperty(example="null", value="Status of asynchronous create operation")
    @JsonProperty(value="createStatus")
    public CreateStatusEnum getCreateStatus() {
        return this.createStatus;
    }

    @ApiModelProperty(example="null", value="Error information returned, if createStatus is set to Error")
    @JsonProperty(value="createError")
    public ErrorBody getCreateError() {
        return this.createError;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WhatsAppIntegration whatsAppIntegration = (WhatsAppIntegration)o;
        return Objects.equals(this.id, whatsAppIntegration.id) && Objects.equals(this.name, whatsAppIntegration.name) && Objects.equals(this.supportedContent, whatsAppIntegration.supportedContent) && Objects.equals(this.messagingSetting, whatsAppIntegration.messagingSetting) && Objects.equals(this.phoneNumber, whatsAppIntegration.phoneNumber) && Objects.equals(this.availablePhoneNumbers, whatsAppIntegration.availablePhoneNumbers) && Objects.equals((Object)this.status, (Object)whatsAppIntegration.status) && Objects.equals(this.recipient, whatsAppIntegration.recipient) && Objects.equals(this.dateCreated, whatsAppIntegration.dateCreated) && Objects.equals(this.dateModified, whatsAppIntegration.dateModified) && Objects.equals(this.createdBy, whatsAppIntegration.createdBy) && Objects.equals(this.modifiedBy, whatsAppIntegration.modifiedBy) && Objects.equals(this.version, whatsAppIntegration.version) && Objects.equals((Object)this.activationStatusCode, (Object)whatsAppIntegration.activationStatusCode) && Objects.equals(this.activationErrorInfo, whatsAppIntegration.activationErrorInfo) && Objects.equals((Object)this.createStatus, (Object)whatsAppIntegration.createStatus) && Objects.equals(this.createError, whatsAppIntegration.createError) && Objects.equals(this.selfUri, whatsAppIntegration.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.supportedContent, this.messagingSetting, this.phoneNumber, this.availablePhoneNumbers, this.status, this.recipient, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.activationStatusCode, this.activationErrorInfo, this.createStatus, this.createError, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WhatsAppIntegration {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    supportedContent: ").append(this.toIndentedString(this.supportedContent)).append("\n");
        sb.append("    messagingSetting: ").append(this.toIndentedString(this.messagingSetting)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    availablePhoneNumbers: ").append(this.toIndentedString(this.availablePhoneNumbers)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    activationStatusCode: ").append(this.toIndentedString((Object)this.activationStatusCode)).append("\n");
        sb.append("    activationErrorInfo: ").append(this.toIndentedString(this.activationErrorInfo)).append("\n");
        sb.append("    createStatus: ").append(this.toIndentedString((Object)this.createStatus)).append("\n");
        sb.append("    createError: ").append(this.toIndentedString(this.createError)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CreateStatusEnumDeserializer.class)
    public static enum CreateStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INITIATED("Initiated"),
        COMPLETED("Completed"),
        ERROR("Error");

        private String value;

        private CreateStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CreateStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CreateStatusEnum value : CreateStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CreateStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CreateStatusEnumDeserializer
    extends StdDeserializer<CreateStatusEnum> {
        public CreateStatusEnumDeserializer() {
            super(CreateStatusEnumDeserializer.class);
        }

        public CreateStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CreateStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ActivationStatusCodeEnumDeserializer.class)
    public static enum ActivationStatusCodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CODESENT("CodeSent"),
        WAITREQUIRED("WaitRequired"),
        ACTIVATIONFAILED("ActivationFailed"),
        CODECONFIRMED("CodeConfirmed"),
        CONFIRMATIONFAILED("ConfirmationFailed"),
        RESENDCODE("ResendCode");

        private String value;

        private ActivationStatusCodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActivationStatusCodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActivationStatusCodeEnum value : ActivationStatusCodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActivationStatusCodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActivationStatusCodeEnumDeserializer
    extends StdDeserializer<ActivationStatusCodeEnum> {
        public ActivationStatusCodeEnumDeserializer() {
            super(ActivationStatusCodeEnumDeserializer.class);
        }

        public ActivationStatusCodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActivationStatusCodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACTIVE("Active"),
        INACTIVE("Inactive"),
        ERROR("Error"),
        STARTING("Starting"),
        INCOMPLETE("Incomplete"),
        DELETING("Deleting"),
        DELETIONFAILED("DeletionFailed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

