/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.RecipientAdditionalIdentifier;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Information about the recipient the message is sent to or received from.")
public class WebMessagingRecipient
implements Serializable {
    private String firstName = null;
    private String lastName = null;
    private String nickname = null;
    private List<RecipientAdditionalIdentifier> additionalIds = new ArrayList<RecipientAdditionalIdentifier>();

    @ApiModelProperty(example="null", value="First name of the recipient.")
    @JsonProperty(value="firstName")
    public String getFirstName() {
        return this.firstName;
    }

    @ApiModelProperty(example="null", value="Last name of the recipient.")
    @JsonProperty(value="lastName")
    public String getLastName() {
        return this.lastName;
    }

    @ApiModelProperty(example="null", value="Nickname or display name of the recipient.")
    @JsonProperty(value="nickname")
    public String getNickname() {
        return this.nickname;
    }

    @ApiModelProperty(example="null", value="List of recipient additional identifiers")
    @JsonProperty(value="additionalIds")
    public List<RecipientAdditionalIdentifier> getAdditionalIds() {
        return this.additionalIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebMessagingRecipient webMessagingRecipient = (WebMessagingRecipient)o;
        return Objects.equals(this.firstName, webMessagingRecipient.firstName) && Objects.equals(this.lastName, webMessagingRecipient.lastName) && Objects.equals(this.nickname, webMessagingRecipient.nickname) && Objects.equals(this.additionalIds, webMessagingRecipient.additionalIds);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.nickname, this.additionalIds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebMessagingRecipient {\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    nickname: ").append(this.toIndentedString(this.nickname)).append("\n");
        sb.append("    additionalIds: ").append(this.toIndentedString(this.additionalIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

