/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.SmsAddress;
import com.mypurecloud.sdk.v2.model.SmsProvisioningStatus;
import com.mypurecloud.sdk.v2.model.User;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class SmsPhoneNumber
implements Serializable {
    private String id = null;
    private String name = null;
    private String phoneNumber = null;
    private PhoneNumberTypeEnum phoneNumberType = null;
    private Boolean provisionedThroughPureCloud = null;
    private PhoneNumberStatusEnum phoneNumberStatus = null;
    private List<CapabilitiesEnum> capabilities = new ArrayList<CapabilitiesEnum>();
    private String countryCode = null;
    private Date dateCreated = null;
    private Date dateModified = null;
    private User createdBy = null;
    private User modifiedBy = null;
    private Integer version = null;
    private Date purchaseDate = null;
    private Date cancellationDate = null;
    private Date renewalDate = null;
    private AutoRenewableEnum autoRenewable = null;
    private SmsAddress addressId = null;
    private ShortCodeBillingTypeEnum shortCodeBillingType = null;
    private SmsProvisioningStatus provisioningStatus = null;
    private String country = null;
    private Boolean supportsSms = null;
    private Boolean supportsMms = null;
    private Boolean supportsVoice = null;
    private String selfUri = null;

    @ApiModelProperty(example="null", value="The globally unique identifier for the object.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public SmsPhoneNumber name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SmsPhoneNumber phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="A phone number provisioned for SMS communications in E.164 format. E.g. +13175555555 or +34234234234")
    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @ApiModelProperty(example="null", value="Type of the phone number provisioned.")
    @JsonProperty(value="phoneNumberType")
    public PhoneNumberTypeEnum getPhoneNumberType() {
        return this.phoneNumberType;
    }

    public SmsPhoneNumber provisionedThroughPureCloud(Boolean provisionedThroughPureCloud) {
        this.provisionedThroughPureCloud = provisionedThroughPureCloud;
        return this;
    }

    @ApiModelProperty(example="null", value="Is set to false, if the phone number is provisioned through a SMS provider, outside of PureCloud")
    @JsonProperty(value="provisionedThroughPureCloud")
    public Boolean getProvisionedThroughPureCloud() {
        return this.provisionedThroughPureCloud;
    }

    public void setProvisionedThroughPureCloud(Boolean provisionedThroughPureCloud) {
        this.provisionedThroughPureCloud = provisionedThroughPureCloud;
    }

    public SmsPhoneNumber phoneNumberStatus(PhoneNumberStatusEnum phoneNumberStatus) {
        this.phoneNumberStatus = phoneNumberStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the provisioned phone number.")
    @JsonProperty(value="phoneNumberStatus")
    public PhoneNumberStatusEnum getPhoneNumberStatus() {
        return this.phoneNumberStatus;
    }

    public void setPhoneNumberStatus(PhoneNumberStatusEnum phoneNumberStatus) {
        this.phoneNumberStatus = phoneNumberStatus;
    }

    @ApiModelProperty(example="null", value="The capabilities of the phone number available for provisioning.")
    @JsonProperty(value="capabilities")
    public List<CapabilitiesEnum> getCapabilities() {
        return this.capabilities;
    }

    public SmsPhoneNumber countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @ApiModelProperty(example="null", value="The ISO 3166-1 alpha-2 country code of the country this phone number is associated with.")
    @JsonProperty(value="countryCode")
    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public SmsPhoneNumber dateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this phone number was provisioned. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateCreated")
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    public SmsPhoneNumber dateModified(Date dateModified) {
        this.dateModified = dateModified;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this phone number was modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="dateModified")
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    public SmsPhoneNumber createdBy(User createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that provisioned this phone number")
    @JsonProperty(value="createdBy")
    public User getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(User createdBy) {
        this.createdBy = createdBy;
    }

    public SmsPhoneNumber modifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @ApiModelProperty(example="null", value="User that last modified this phone number")
    @JsonProperty(value="modifiedBy")
    public User getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(User modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public SmsPhoneNumber version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Version number required for updates.")
    @JsonProperty(value="version")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public SmsPhoneNumber purchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date this phone number was purchased, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="purchaseDate")
    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public void setPurchaseDate(Date purchaseDate) {
        this.purchaseDate = purchaseDate;
    }

    public SmsPhoneNumber cancellationDate(Date cancellationDate) {
        this.cancellationDate = cancellationDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Contract end date of this phone number, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="cancellationDate")
    public Date getCancellationDate() {
        return this.cancellationDate;
    }

    public void setCancellationDate(Date cancellationDate) {
        this.cancellationDate = cancellationDate;
    }

    public SmsPhoneNumber renewalDate(Date renewalDate) {
        this.renewalDate = renewalDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Contract renewal date of this phone number, if the phoneNumberType is shortcode. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="renewalDate")
    public Date getRenewalDate() {
        return this.renewalDate;
    }

    public void setRenewalDate(Date renewalDate) {
        this.renewalDate = renewalDate;
    }

    public SmsPhoneNumber autoRenewable(AutoRenewableEnum autoRenewable) {
        this.autoRenewable = autoRenewable;
        return this;
    }

    @ApiModelProperty(example="null", value="Renewal time period of this phone number, if the phoneNumberType is shortcode.")
    @JsonProperty(value="autoRenewable")
    public AutoRenewableEnum getAutoRenewable() {
        return this.autoRenewable;
    }

    public void setAutoRenewable(AutoRenewableEnum autoRenewable) {
        this.autoRenewable = autoRenewable;
    }

    public SmsPhoneNumber addressId(SmsAddress addressId) {
        this.addressId = addressId;
        return this;
    }

    @ApiModelProperty(example="null", value="The id of an address attached to this phone number.")
    @JsonProperty(value="addressId")
    public SmsAddress getAddressId() {
        return this.addressId;
    }

    public void setAddressId(SmsAddress addressId) {
        this.addressId = addressId;
    }

    public SmsPhoneNumber shortCodeBillingType(ShortCodeBillingTypeEnum shortCodeBillingType) {
        this.shortCodeBillingType = shortCodeBillingType;
        return this;
    }

    @ApiModelProperty(example="null", value="BillingType of this phone number, if the phoneNumberType is shortcode.")
    @JsonProperty(value="shortCodeBillingType")
    public ShortCodeBillingTypeEnum getShortCodeBillingType() {
        return this.shortCodeBillingType;
    }

    public void setShortCodeBillingType(ShortCodeBillingTypeEnum shortCodeBillingType) {
        this.shortCodeBillingType = shortCodeBillingType;
    }

    public SmsPhoneNumber provisioningStatus(SmsProvisioningStatus provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of latest asynchronous provisioning action")
    @JsonProperty(value="provisioningStatus")
    public SmsProvisioningStatus getProvisioningStatus() {
        return this.provisioningStatus;
    }

    public void setProvisioningStatus(SmsProvisioningStatus provisioningStatus) {
        this.provisioningStatus = provisioningStatus;
    }

    public SmsPhoneNumber country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="null", value="Localized country name for the country code this phone number belongs too")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public SmsPhoneNumber supportsSms(Boolean supportsSms) {
        this.supportsSms = supportsSms;
        return this;
    }

    @ApiModelProperty(example="null", value="Set to true if this phone number has the capability to support SMS")
    @JsonProperty(value="supportsSms")
    public Boolean getSupportsSms() {
        return this.supportsSms;
    }

    public void setSupportsSms(Boolean supportsSms) {
        this.supportsSms = supportsSms;
    }

    public SmsPhoneNumber supportsMms(Boolean supportsMms) {
        this.supportsMms = supportsMms;
        return this;
    }

    @ApiModelProperty(example="null", value="Set to true if this phone number has the capability to support MMS")
    @JsonProperty(value="supportsMms")
    public Boolean getSupportsMms() {
        return this.supportsMms;
    }

    public void setSupportsMms(Boolean supportsMms) {
        this.supportsMms = supportsMms;
    }

    public SmsPhoneNumber supportsVoice(Boolean supportsVoice) {
        this.supportsVoice = supportsVoice;
        return this;
    }

    @ApiModelProperty(example="null", value="Set to true if this phone number has the capability to support voice")
    @JsonProperty(value="supportsVoice")
    public Boolean getSupportsVoice() {
        return this.supportsVoice;
    }

    public void setSupportsVoice(Boolean supportsVoice) {
        this.supportsVoice = supportsVoice;
    }

    @ApiModelProperty(example="null", value="The URI for this object")
    @JsonProperty(value="selfUri")
    public String getSelfUri() {
        return this.selfUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SmsPhoneNumber smsPhoneNumber = (SmsPhoneNumber)o;
        return Objects.equals(this.id, smsPhoneNumber.id) && Objects.equals(this.name, smsPhoneNumber.name) && Objects.equals(this.phoneNumber, smsPhoneNumber.phoneNumber) && Objects.equals((Object)this.phoneNumberType, (Object)smsPhoneNumber.phoneNumberType) && Objects.equals(this.provisionedThroughPureCloud, smsPhoneNumber.provisionedThroughPureCloud) && Objects.equals((Object)this.phoneNumberStatus, (Object)smsPhoneNumber.phoneNumberStatus) && Objects.equals(this.capabilities, smsPhoneNumber.capabilities) && Objects.equals(this.countryCode, smsPhoneNumber.countryCode) && Objects.equals(this.dateCreated, smsPhoneNumber.dateCreated) && Objects.equals(this.dateModified, smsPhoneNumber.dateModified) && Objects.equals(this.createdBy, smsPhoneNumber.createdBy) && Objects.equals(this.modifiedBy, smsPhoneNumber.modifiedBy) && Objects.equals(this.version, smsPhoneNumber.version) && Objects.equals(this.purchaseDate, smsPhoneNumber.purchaseDate) && Objects.equals(this.cancellationDate, smsPhoneNumber.cancellationDate) && Objects.equals(this.renewalDate, smsPhoneNumber.renewalDate) && Objects.equals((Object)this.autoRenewable, (Object)smsPhoneNumber.autoRenewable) && Objects.equals(this.addressId, smsPhoneNumber.addressId) && Objects.equals((Object)this.shortCodeBillingType, (Object)smsPhoneNumber.shortCodeBillingType) && Objects.equals(this.provisioningStatus, smsPhoneNumber.provisioningStatus) && Objects.equals(this.country, smsPhoneNumber.country) && Objects.equals(this.supportsSms, smsPhoneNumber.supportsSms) && Objects.equals(this.supportsMms, smsPhoneNumber.supportsMms) && Objects.equals(this.supportsVoice, smsPhoneNumber.supportsVoice) && Objects.equals(this.selfUri, smsPhoneNumber.selfUri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.phoneNumber, this.phoneNumberType, this.provisionedThroughPureCloud, this.phoneNumberStatus, this.capabilities, this.countryCode, this.dateCreated, this.dateModified, this.createdBy, this.modifiedBy, this.version, this.purchaseDate, this.cancellationDate, this.renewalDate, this.autoRenewable, this.addressId, this.shortCodeBillingType, this.provisioningStatus, this.country, this.supportsSms, this.supportsMms, this.supportsVoice, this.selfUri});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsPhoneNumber {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    phoneNumberType: ").append(this.toIndentedString((Object)this.phoneNumberType)).append("\n");
        sb.append("    provisionedThroughPureCloud: ").append(this.toIndentedString(this.provisionedThroughPureCloud)).append("\n");
        sb.append("    phoneNumberStatus: ").append(this.toIndentedString((Object)this.phoneNumberStatus)).append("\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateModified: ").append(this.toIndentedString(this.dateModified)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    purchaseDate: ").append(this.toIndentedString(this.purchaseDate)).append("\n");
        sb.append("    cancellationDate: ").append(this.toIndentedString(this.cancellationDate)).append("\n");
        sb.append("    renewalDate: ").append(this.toIndentedString(this.renewalDate)).append("\n");
        sb.append("    autoRenewable: ").append(this.toIndentedString((Object)this.autoRenewable)).append("\n");
        sb.append("    addressId: ").append(this.toIndentedString(this.addressId)).append("\n");
        sb.append("    shortCodeBillingType: ").append(this.toIndentedString((Object)this.shortCodeBillingType)).append("\n");
        sb.append("    provisioningStatus: ").append(this.toIndentedString(this.provisioningStatus)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    supportsSms: ").append(this.toIndentedString(this.supportsSms)).append("\n");
        sb.append("    supportsMms: ").append(this.toIndentedString(this.supportsMms)).append("\n");
        sb.append("    supportsVoice: ").append(this.toIndentedString(this.supportsVoice)).append("\n");
        sb.append("    selfUri: ").append(this.toIndentedString(this.selfUri)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ShortCodeBillingTypeEnumDeserializer.class)
    public static enum ShortCodeBillingTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        BASIC("Basic"),
        VANITY("Vanity");

        private String value;

        private ShortCodeBillingTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ShortCodeBillingTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ShortCodeBillingTypeEnum value : ShortCodeBillingTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ShortCodeBillingTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ShortCodeBillingTypeEnumDeserializer
    extends StdDeserializer<ShortCodeBillingTypeEnum> {
        public ShortCodeBillingTypeEnumDeserializer() {
            super(ShortCodeBillingTypeEnumDeserializer.class);
        }

        public ShortCodeBillingTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ShortCodeBillingTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=AutoRenewableEnumDeserializer.class)
    public static enum AutoRenewableEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUARTERLY("Quarterly");

        private String value;

        private AutoRenewableEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AutoRenewableEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AutoRenewableEnum value : AutoRenewableEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AutoRenewableEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AutoRenewableEnumDeserializer
    extends StdDeserializer<AutoRenewableEnum> {
        public AutoRenewableEnumDeserializer() {
            super(AutoRenewableEnumDeserializer.class);
        }

        public AutoRenewableEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AutoRenewableEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=CapabilitiesEnumDeserializer.class)
    public static enum CapabilitiesEnum {
        SMS("sms"),
        MMS("mms"),
        VOICE("voice");

        private String value;

        private CapabilitiesEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CapabilitiesEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CapabilitiesEnum value : CapabilitiesEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CapabilitiesEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CapabilitiesEnumDeserializer
    extends StdDeserializer<CapabilitiesEnum> {
        public CapabilitiesEnumDeserializer() {
            super(CapabilitiesEnumDeserializer.class);
        }

        public CapabilitiesEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CapabilitiesEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=PhoneNumberStatusEnumDeserializer.class)
    public static enum PhoneNumberStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INVALID("INVALID"),
        ACTIVE("ACTIVE"),
        PORTING("PORTING"),
        PENDING("PENDING"),
        PENDING_CANCELLATION("PENDING_CANCELLATION"),
        INITIATED("INITIATED");

        private String value;

        private PhoneNumberStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneNumberStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneNumberStatusEnum value : PhoneNumberStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneNumberStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneNumberStatusEnumDeserializer
    extends StdDeserializer<PhoneNumberStatusEnum> {
        public PhoneNumberStatusEnumDeserializer() {
            super(PhoneNumberStatusEnumDeserializer.class);
        }

        public PhoneNumberStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneNumberStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=PhoneNumberTypeEnumDeserializer.class)
    public static enum PhoneNumberTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        LOCAL("local"),
        MOBILE("mobile"),
        TOLLFREE("tollfree"),
        SHORTCODE("shortcode");

        private String value;

        private PhoneNumberTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static PhoneNumberTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (PhoneNumberTypeEnum value : PhoneNumberTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return PhoneNumberTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class PhoneNumberTypeEnumDeserializer
    extends StdDeserializer<PhoneNumberTypeEnum> {
        public PhoneNumberTypeEnumDeserializer() {
            super(PhoneNumberTypeEnumDeserializer.class);
        }

        public PhoneNumberTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return PhoneNumberTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

