/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.MessagingTemplateRequest;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

public class SendAgentlessOutboundMessageRequest
implements Serializable {
    private String fromAddress = null;
    private String toAddress = null;
    private ToAddressMessengerTypeEnum toAddressMessengerType = null;
    private String textBody = null;
    private MessagingTemplateRequest messagingTemplate = null;
    private Boolean useExistingActiveConversation = null;

    public SendAgentlessOutboundMessageRequest fromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging address of the sender of the message. For an SMS messenger type, this must be a currently provisioned SMS phone number. For a WhatsApp messenger type use the provisioned WhatsApp integration\u2019s ID")
    @JsonProperty(value="fromAddress")
    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public SendAgentlessOutboundMessageRequest toAddress(String toAddress) {
        this.toAddress = toAddress;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The messaging address of the recipient of the message. For an SMS messenger type, the phone number address must be in E.164 format. E.g. +13175555555 or +34234234234.")
    @JsonProperty(value="toAddress")
    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public SendAgentlessOutboundMessageRequest toAddressMessengerType(ToAddressMessengerTypeEnum toAddressMessengerType) {
        this.toAddressMessengerType = toAddressMessengerType;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The recipient messaging address messenger type.")
    @JsonProperty(value="toAddressMessengerType")
    public ToAddressMessengerTypeEnum getToAddressMessengerType() {
        return this.toAddressMessengerType;
    }

    public void setToAddressMessengerType(ToAddressMessengerTypeEnum toAddressMessengerType) {
        this.toAddressMessengerType = toAddressMessengerType;
    }

    public SendAgentlessOutboundMessageRequest textBody(String textBody) {
        this.textBody = textBody;
        return this;
    }

    @ApiModelProperty(example="null", value="The text of the message to send. This field is required in the case of SMS messenger type. Maximum character counts are: SMS - 765 characters, other channels - 2000 characters.")
    @JsonProperty(value="textBody")
    public String getTextBody() {
        return this.textBody;
    }

    public void setTextBody(String textBody) {
        this.textBody = textBody;
    }

    public SendAgentlessOutboundMessageRequest messagingTemplate(MessagingTemplateRequest messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
        return this;
    }

    @ApiModelProperty(example="null", value="The messaging template to use in the case of WhatsApp messenger type. This field is required when using WhatsApp messenger type")
    @JsonProperty(value="messagingTemplate")
    public MessagingTemplateRequest getMessagingTemplate() {
        return this.messagingTemplate;
    }

    public void setMessagingTemplate(MessagingTemplateRequest messagingTemplate) {
        this.messagingTemplate = messagingTemplate;
    }

    public SendAgentlessOutboundMessageRequest useExistingActiveConversation(Boolean useExistingActiveConversation) {
        this.useExistingActiveConversation = useExistingActiveConversation;
        return this;
    }

    @ApiModelProperty(example="null", value="Use an existing active conversation to send the agentless outbound message. Set this parameter to 'true' to use active conversation. Default value: false")
    @JsonProperty(value="useExistingActiveConversation")
    public Boolean getUseExistingActiveConversation() {
        return this.useExistingActiveConversation;
    }

    public void setUseExistingActiveConversation(Boolean useExistingActiveConversation) {
        this.useExistingActiveConversation = useExistingActiveConversation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SendAgentlessOutboundMessageRequest sendAgentlessOutboundMessageRequest = (SendAgentlessOutboundMessageRequest)o;
        return Objects.equals(this.fromAddress, sendAgentlessOutboundMessageRequest.fromAddress) && Objects.equals(this.toAddress, sendAgentlessOutboundMessageRequest.toAddress) && Objects.equals((Object)this.toAddressMessengerType, (Object)sendAgentlessOutboundMessageRequest.toAddressMessengerType) && Objects.equals(this.textBody, sendAgentlessOutboundMessageRequest.textBody) && Objects.equals(this.messagingTemplate, sendAgentlessOutboundMessageRequest.messagingTemplate) && Objects.equals(this.useExistingActiveConversation, sendAgentlessOutboundMessageRequest.useExistingActiveConversation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fromAddress, this.toAddress, this.toAddressMessengerType, this.textBody, this.messagingTemplate, this.useExistingActiveConversation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SendAgentlessOutboundMessageRequest {\n");
        sb.append("    fromAddress: ").append(this.toIndentedString(this.fromAddress)).append("\n");
        sb.append("    toAddress: ").append(this.toIndentedString(this.toAddress)).append("\n");
        sb.append("    toAddressMessengerType: ").append(this.toIndentedString((Object)this.toAddressMessengerType)).append("\n");
        sb.append("    textBody: ").append(this.toIndentedString(this.textBody)).append("\n");
        sb.append("    messagingTemplate: ").append(this.toIndentedString(this.messagingTemplate)).append("\n");
        sb.append("    useExistingActiveConversation: ").append(this.toIndentedString(this.useExistingActiveConversation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ToAddressMessengerTypeEnumDeserializer.class)
    public static enum ToAddressMessengerTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SMS("sms"),
        WHATSAPP("whatsapp"),
        OPEN("open");

        private String value;

        private ToAddressMessengerTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ToAddressMessengerTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ToAddressMessengerTypeEnum value : ToAddressMessengerTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ToAddressMessengerTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ToAddressMessengerTypeEnumDeserializer
    extends StdDeserializer<ToAddressMessengerTypeEnum> {
        public ToAddressMessengerTypeEnumDeserializer() {
            super(ToAddressMessengerTypeEnumDeserializer.class);
        }

        public ToAddressMessengerTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ToAddressMessengerTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

