/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

public class AnalyticsRoutingStatusRecord
implements Serializable {
    private Date startTime = null;
    private Date endTime = null;
    private RoutingStatusEnum routingStatus = null;

    public AnalyticsRoutingStatusRecord startTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The start time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startTime")
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public AnalyticsRoutingStatusRecord endTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The end time of the record. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="endTime")
    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public AnalyticsRoutingStatusRecord routingStatus(RoutingStatusEnum routingStatus) {
        this.routingStatus = routingStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="The user's ACD routing status")
    @JsonProperty(value="routingStatus")
    public RoutingStatusEnum getRoutingStatus() {
        return this.routingStatus;
    }

    public void setRoutingStatus(RoutingStatusEnum routingStatus) {
        this.routingStatus = routingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsRoutingStatusRecord analyticsRoutingStatusRecord = (AnalyticsRoutingStatusRecord)o;
        return Objects.equals(this.startTime, analyticsRoutingStatusRecord.startTime) && Objects.equals(this.endTime, analyticsRoutingStatusRecord.endTime) && Objects.equals((Object)this.routingStatus, (Object)analyticsRoutingStatusRecord.routingStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startTime, this.endTime, this.routingStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AnalyticsRoutingStatusRecord {\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    endTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("    routingStatus: ").append(this.toIndentedString((Object)this.routingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=RoutingStatusEnumDeserializer.class)
    public static enum RoutingStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        OFF_QUEUE("OFF_QUEUE"),
        IDLE("IDLE"),
        INTERACTING("INTERACTING"),
        NOT_RESPONDING("NOT_RESPONDING"),
        COMMUNICATING("COMMUNICATING");

        private String value;

        private RoutingStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static RoutingStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (RoutingStatusEnum value : RoutingStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return RoutingStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class RoutingStatusEnumDeserializer
    extends StdDeserializer<RoutingStatusEnum> {
        public RoutingStatusEnumDeserializer() {
            super(RoutingStatusEnumDeserializer.class);
        }

        public RoutingStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return RoutingStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

