/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AddressableEntityRef;
import com.mypurecloud.sdk.v2.model.DomainEntityRef;
import com.mypurecloud.sdk.v2.model.MessageInfo;
import com.mypurecloud.sdk.v2.model.PropertyChange;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AuditLogMessage
implements Serializable {
    private String id = null;
    private String userHomeOrgId = null;
    private DomainEntityRef user = null;
    private AddressableEntityRef client = null;
    private List<String> remoteIp = new ArrayList<String>();
    private ServiceNameEnum serviceName = null;
    private Date eventDate = null;
    private MessageInfo message = null;
    private ActionEnum action = null;
    private DomainEntityRef entity = null;
    private EntityTypeEnum entityType = null;
    private StatusEnum status = null;
    private List<PropertyChange> propertyChanges = new ArrayList<PropertyChange>();
    private Map<String, String> context = null;

    public AuditLogMessage id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the audit message.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditLogMessage userHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
        return this;
    }

    @ApiModelProperty(example="null", value="Home Organization Id associated with this audit message.")
    @JsonProperty(value="userHomeOrgId")
    public String getUserHomeOrgId() {
        return this.userHomeOrgId;
    }

    public void setUserHomeOrgId(String userHomeOrgId) {
        this.userHomeOrgId = userHomeOrgId;
    }

    public AuditLogMessage user(DomainEntityRef user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(example="null", value="User associated with this audit message.")
    @JsonProperty(value="user")
    public DomainEntityRef getUser() {
        return this.user;
    }

    public void setUser(DomainEntityRef user) {
        this.user = user;
    }

    public AuditLogMessage client(AddressableEntityRef client) {
        this.client = client;
        return this;
    }

    @ApiModelProperty(example="null", value="Client associated with this audit message.")
    @JsonProperty(value="client")
    public AddressableEntityRef getClient() {
        return this.client;
    }

    public void setClient(AddressableEntityRef client) {
        this.client = client;
    }

    public AuditLogMessage remoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
        return this;
    }

    @ApiModelProperty(example="null", value="List of IP addresses of systems that originated or handled the request.")
    @JsonProperty(value="remoteIp")
    public List<String> getRemoteIp() {
        return this.remoteIp;
    }

    public void setRemoteIp(List<String> remoteIp) {
        this.remoteIp = remoteIp;
    }

    public AuditLogMessage serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the service that logged this audit message.")
    @JsonProperty(value="serviceName")
    public ServiceNameEnum getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public AuditLogMessage eventDate(Date eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Date and time of when the audit message was logged. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="eventDate")
    public Date getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public AuditLogMessage message(MessageInfo message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", value="Message describing the event being audited.")
    @JsonProperty(value="message")
    public MessageInfo getMessage() {
        return this.message;
    }

    public void setMessage(MessageInfo message) {
        this.message = message;
    }

    public AuditLogMessage action(ActionEnum action) {
        this.action = action;
        return this;
    }

    @ApiModelProperty(example="null", value="Action that took place.")
    @JsonProperty(value="action")
    public ActionEnum getAction() {
        return this.action;
    }

    public void setAction(ActionEnum action) {
        this.action = action;
    }

    public AuditLogMessage entity(DomainEntityRef entity) {
        this.entity = entity;
        return this;
    }

    @ApiModelProperty(example="null", value="Entity that was impacted.")
    @JsonProperty(value="entity")
    public DomainEntityRef getEntity() {
        return this.entity;
    }

    public void setEntity(DomainEntityRef entity) {
        this.entity = entity;
    }

    public AuditLogMessage entityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
        return this;
    }

    @ApiModelProperty(example="null", value="Type of the entity that was impacted.")
    @JsonProperty(value="entityType")
    public EntityTypeEnum getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityTypeEnum entityType) {
        this.entityType = entityType;
    }

    public AuditLogMessage status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the event being audited")
    @JsonProperty(value="status")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public AuditLogMessage propertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
        return this;
    }

    @ApiModelProperty(example="null", value="List of properties that were changed and changes made to those properties.")
    @JsonProperty(value="propertyChanges")
    public List<PropertyChange> getPropertyChanges() {
        return this.propertyChanges;
    }

    public void setPropertyChanges(List<PropertyChange> propertyChanges) {
        this.propertyChanges = propertyChanges;
    }

    public AuditLogMessage context(Map<String, String> context) {
        this.context = context;
        return this;
    }

    @ApiModelProperty(example="null", value="Additional context for this message.")
    @JsonProperty(value="context")
    public Map<String, String> getContext() {
        return this.context;
    }

    public void setContext(Map<String, String> context) {
        this.context = context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogMessage auditLogMessage = (AuditLogMessage)o;
        return Objects.equals(this.id, auditLogMessage.id) && Objects.equals(this.userHomeOrgId, auditLogMessage.userHomeOrgId) && Objects.equals(this.user, auditLogMessage.user) && Objects.equals(this.client, auditLogMessage.client) && Objects.equals(this.remoteIp, auditLogMessage.remoteIp) && Objects.equals((Object)this.serviceName, (Object)auditLogMessage.serviceName) && Objects.equals(this.eventDate, auditLogMessage.eventDate) && Objects.equals(this.message, auditLogMessage.message) && Objects.equals((Object)this.action, (Object)auditLogMessage.action) && Objects.equals(this.entity, auditLogMessage.entity) && Objects.equals((Object)this.entityType, (Object)auditLogMessage.entityType) && Objects.equals((Object)this.status, (Object)auditLogMessage.status) && Objects.equals(this.propertyChanges, auditLogMessage.propertyChanges) && Objects.equals(this.context, auditLogMessage.context);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userHomeOrgId, this.user, this.client, this.remoteIp, this.serviceName, this.eventDate, this.message, this.action, this.entity, this.entityType, this.status, this.propertyChanges, this.context});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditLogMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    userHomeOrgId: ").append(this.toIndentedString(this.userHomeOrgId)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    client: ").append(this.toIndentedString(this.client)).append("\n");
        sb.append("    remoteIp: ").append(this.toIndentedString(this.remoteIp)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString((Object)this.serviceName)).append("\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    entity: ").append(this.toIndentedString(this.entity)).append("\n");
        sb.append("    entityType: ").append(this.toIndentedString((Object)this.entityType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    propertyChanges: ").append(this.toIndentedString(this.propertyChanges)).append("\n");
        sb.append("    context: ").append(this.toIndentedString(this.context)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=StatusEnumDeserializer.class)
    public static enum StatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        SUCCESS("SUCCESS"),
        FAILURE("FAILURE"),
        WARNING("WARNING");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StatusEnum value : StatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StatusEnumDeserializer
    extends StdDeserializer<StatusEnum> {
        public StatusEnumDeserializer() {
            super(StatusEnumDeserializer.class);
        }

        public StatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=EntityTypeEnumDeserializer.class)
    public static enum EntityTypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ACCESSTOKEN("AccessToken"),
        ACTION("Action"),
        ACTIONDRAFT("ActionDraft"),
        ACTIONMAP("ActionMap"),
        ACTIONTEMPLATE("ActionTemplate"),
        ACTIVITYCODE("ActivityCode"),
        ADHERENCEEXPLANATION("AdherenceExplanation"),
        AGENTROUTINGINFO("AgentRoutingInfo"),
        ANALYTICSREPORTINGSETTINGS("AnalyticsReportingSettings"),
        ANNOTATION("Annotation"),
        APPOINTMENT("Appointment"),
        ASSIGNMENT("Assignment"),
        ATTEMPTLIMITS("AttemptLimits"),
        AUTHORGANIZATION("AuthOrganization"),
        AUTHUSER("AuthUser"),
        BULK("Bulk"),
        BULKACTIONS("BulkActions"),
        BUSINESSUNIT("BusinessUnit"),
        CALIBRATION("Calibration"),
        CALLABLETIMESET("CallableTimeSet"),
        CALLANALYSISRESPONSESET("CallAnalysisResponseSet"),
        CAMPAIGN("Campaign"),
        CAMPAIGNRULE("CampaignRule"),
        CAMPAIGNSCHEDULE("CampaignSchedule"),
        CHANGEREQUEST("ChangeRequest"),
        CLICKSTREAMSETTINGS("ClickstreamSettings"),
        CONFIGURATION("Configuration"),
        CONFIGURATIONVERSION("ConfigurationVersion"),
        CONTACTLIST("ContactList"),
        CONTACTLISTFILTER("ContactListFilter"),
        CONTACTSCHEMA("ContactSchema"),
        CONVERSATIONATTRIBUTES("ConversationAttributes"),
        CONVERSATIONACCOUNT("ConversationAccount"),
        CONVERSATIONDEFAULTSUPPORTEDCONTENT("ConversationDefaultSupportedContent"),
        CONVERSATIONPHONENUMBER("ConversationPhoneNumber"),
        CONVERSATIONRECIPIENT("ConversationRecipient"),
        CONVERSATIONTHREADINGWINDOW("ConversationThreadingWindow"),
        CREDENTIAL("Credential"),
        DASHBOARDSETTINGS("DashboardSettings"),
        DEPENDENCYTRACKINGBUILD("DependencyTrackingBuild"),
        DEPLOYMENT("Deployment"),
        DID("DID"),
        DIDPOOL("DIDPool"),
        DNCLIST("DNCList"),
        DOCUMENT("Document"),
        DYNAMICGROUP("DynamicGroup"),
        DYNAMICSCHEMA("DynamicSchema"),
        EDGE("Edge"),
        EDGEGROUP("EdgeGroup"),
        EDGELOG("EdgeLog"),
        EDGELOGZIP("EdgeLogZip"),
        EDGEPCAPS("EdgePcaps"),
        EDGEPREFERENCES("EdgePreferences"),
        EDGETRACELEVEL("EdgeTraceLevel"),
        EMERGENCYGROUP("EmergencyGroup"),
        EVALUATION("Evaluation"),
        EVALUATIONFORM("EvaluationForm"),
        EVENTTYPE("EventType"),
        EXPORTS("Exports"),
        EXTENSION("Extension"),
        EXTENSIONPOOL("ExtensionPool"),
        EXTERNALMETRICSDATA("ExternalMetricsData"),
        EXTERNALMETRICSDEFINITION("ExternalMetricsDefinition"),
        EXTERNALORGANIZATIONSCHEMA("ExternalOrganizationSchema"),
        FEEDBACK("Feedback"),
        FLOW("Flow"),
        FLOWMILESTONE("FlowMilestone"),
        FLOWOUTCOME("FlowOutcome"),
        FORECAST("Forecast"),
        HISTORICALDATA("HistoricalData"),
        INSIGHTSETTINGS("InsightSettings"),
        INTEGRATION("Integration"),
        IVR("IVR"),
        KNOWLEDGEBASE("KnowledgeBase"),
        KNOWLEDGECATEGORY("KnowledgeCategory"),
        KNOWLEDGEDOCUMENT("KnowledgeDocument"),
        KNOWLEDGEDOCUMENTVARIATION("KnowledgeDocumentVariation"),
        KNOWLEDGESEARCHFEEDBACK("KnowledgeSearchFeedback"),
        KNOWLEDGETRAINING("KnowledgeTraining"),
        LINE("Line"),
        LINEBASE("LineBase"),
        LOCATION("Location"),
        MANAGEMENTUNIT("ManagementUnit"),
        MAXORGROUTINGUTILIZATIONCAPACITY("MaxOrgRoutingUtilizationCapacity"),
        MEDIADIAGNOSTICSTRACEFILE("MediaDiagnosticsTraceFile"),
        MESSAGINGCAMPAIGN("MessagingCampaign"),
        METRIC("Metric"),
        MODULE("Module"),
        NUMBERORDER("NumberOrder"),
        NUMBERPLAN("NumberPlan"),
        OAUTHCLIENT("OAuthClient"),
        OAUTHCLIENTAUTHORIZATION("OAuthClientAuthorization"),
        ORGANIZATIONAUTHORIZATIONTRUST("OrganizationAuthorizationTrust"),
        ORGANIZATIONAUTHORIZATIONUSERTRUST("OrganizationAuthorizationUserTrust"),
        ORGANIZATIONFEATURE("OrganizationFeature"),
        ORGANIZATIONINTEGRATIONSACCESS("OrganizationIntegrationsAccess"),
        ORGANIZATIONSETTINGS("OrganizationSettings"),
        ORPHANEDRECORDING("OrphanedRecording"),
        OUTBOUNDROUTE("OutboundRoute"),
        OUTCOME("Outcome"),
        PCAPS("Pcaps"),
        PHONE("Phone"),
        PHONEBASE("PhoneBase"),
        PLANNINGGROUP("PlanningGroup"),
        POLICY("Policy"),
        PREDICTOR("Predictor"),
        PRODUCT("Product"),
        PROFILE("Profile"),
        PROFILEMEMBERS("ProfileMembers"),
        PROGRAM("Program"),
        PROMPT("Prompt"),
        PROMPTRESOURCE("PromptResource"),
        QUEUE("Queue"),
        RECORDING("Recording"),
        RECORDINGANNOTATION("RecordingAnnotation"),
        RECORDINGSETTINGS("RecordingSettings"),
        RESPONSE("Response"),
        RESPONSEASSET("ResponseAsset"),
        ROLE("Role"),
        ROW("Row"),
        ROUTINGTRANSCRIPTIONSETTINGS("RoutingTranscriptionSettings"),
        ROUTINGUTILIZATIONTAG("RoutingUtilizationTag"),
        RULE("Rule"),
        RULESET("RuleSet"),
        SCHEDULE("Schedule"),
        SCHEDULEDEXPORTS("ScheduledExports"),
        SCHEDULEGROUP("ScheduleGroup"),
        SCHEMA("Schema"),
        SCREENRECORDING("ScreenRecording"),
        SEGMENT("Segment"),
        SENTIMENTFEEDBACK("SentimentFeedback"),
        SEQUENCE("Sequence"),
        SEQUENCESCHEDULE("SequenceSchedule"),
        SERVICEGOALTEMPLATE("ServiceGoalTemplate"),
        SESSIONTYPE("SessionType"),
        SHIFTTRADE("ShiftTrade"),
        SITE("Site"),
        SPEECHTEXTANALYTICSSETTINGS("SpeechTextAnalyticsSettings"),
        STATUS("Status"),
        SUPPORTEDCONTENT("SupportedContent"),
        SUPPORTFILE("SupportFile"),
        SURVEY("Survey"),
        SURVEYFORM("SurveyForm"),
        TEAM("Team"),
        TIMEOFFLIMIT("TimeOffLimit"),
        TIMEOFFPLAN("TimeOffPlan"),
        TIMEOFFREQUEST("TimeOffRequest"),
        TOPIC("Topic"),
        TRANSCRIPTIONSETTINGS("TranscriptionSettings"),
        TRIGGER("Trigger"),
        TRUNK("Trunk"),
        TRUNKBASE("TrunkBase"),
        USER("User"),
        USERPRESENCE("UserPresence"),
        VOICEMAILPOLICY("VoicemailPolicy"),
        VOICEMAILUSERPOLICY("VoicemailUserPolicy"),
        WEBHOOK("Webhook"),
        WORKBIN("Workbin"),
        WORKITEM("Workitem"),
        WORKPLAN("WorkPlan"),
        WORKPLANROTATION("WorkPlanRotation"),
        WORKSPACE("Workspace"),
        WORKTYPE("Worktype"),
        WRAPUPCODE("WrapupCode"),
        WRAPUPCODEMAPPING("WrapUpCodeMapping"),
        PARTICIPANT("Participant");

        private String value;

        private EntityTypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static EntityTypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (EntityTypeEnum value : EntityTypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return EntityTypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class EntityTypeEnumDeserializer
    extends StdDeserializer<EntityTypeEnum> {
        public EntityTypeEnumDeserializer() {
            super(EntityTypeEnumDeserializer.class);
        }

        public EntityTypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return EntityTypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ActionEnumDeserializer.class)
    public static enum ActionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        CREATE("Create"),
        VIEW("View"),
        UPDATE("Update"),
        MOVE("Move"),
        COPY("Copy"),
        DELETE("Delete"),
        DELETEALL("DeleteAll"),
        FAX("Fax"),
        VERSIONCREATE("VersionCreate"),
        DOWNLOAD("Download"),
        UPLOAD("Upload"),
        MEMBERADD("MemberAdd"),
        MEMBERUPDATE("MemberUpdate"),
        MEMBERREMOVE("MemberRemove"),
        SHAREADD("ShareAdd"),
        SHAREREMOVE("ShareRemove"),
        TAGADD("TagAdd"),
        TAGREMOVE("TagRemove"),
        TAGUPDATE("TagUpdate"),
        READ("Read"),
        READALL("ReadAll"),
        EXECUTE("Execute"),
        APPLYPROTECTION("ApplyProtection"),
        REVOKEPROTECTION("RevokeProtection"),
        UPDATERETENTION("UpdateRetention"),
        ABANDON("Abandon"),
        ARCHIVE("Archive"),
        RESTOREREQUEST("RestoreRequest"),
        RESTORECOMPLETE("RestoreComplete"),
        PROMOTE("Promote"),
        PUBLISH("Publish"),
        UNPUBLISH("Unpublish"),
        ACTIVATE("Activate"),
        CHECKIN("Checkin"),
        CHECKOUT("Checkout"),
        DEACTIVATE("Deactivate"),
        DEBUG("Debug"),
        SAVE("Save"),
        REVERT("Revert"),
        TRANSCODE("Transcode"),
        ENABLE("Enable"),
        DISABLE("Disable"),
        AUTHORIZE("Authorize"),
        DEAUTHORIZE("Deauthorize"),
        AUTHENTICATE("Authenticate"),
        CHANGEPASSWORD("ChangePassword"),
        REVOKE("Revoke"),
        EXPORT("Export"),
        APPEND("Append"),
        RECYCLE("Recycle"),
        OPEN("Open"),
        APPROVED("Approved"),
        REJECTED("Rejected"),
        ROLLBACK("Rollback"),
        IMPLEMENTINGCHANGE("ImplementingChange"),
        CHANGEIMPLEMENTED("ChangeImplemented"),
        IMPLEMENTINGROLLBACK("ImplementingRollback"),
        ROLLBACKIMPLEMENTED("RollbackImplemented"),
        WRITE("Write"),
        PURGE("Purge"),
        PROCESSED("Processed"),
        REPLACE("Replace"),
        UPDATEINSERVICE("UpdateInService"),
        UPDATEOUTOFSERVICE("UpdateOutOfService"),
        CYCLE("Cycle"),
        SCALE("Scale"),
        IPALLOWLISTCLEAR("IpAllowlistClear"),
        ADDPAIRINGROLE("AddPairingRole"),
        ADD("Add"),
        VERIFY("Verify"),
        ASSIGN("Assign"),
        UNASSIGN("Unassign"),
        REASSIGN("Reassign"),
        RESCHEDULE("Reschedule"),
        CANCEL("Cancel"),
        SOFTDELETE("SoftDelete"),
        HARDDELETE("HardDelete"),
        RESET("Reset"),
        UNARCHIVE("Unarchive");

        private String value;

        private ActionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ActionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ActionEnum value : ActionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ActionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ActionEnumDeserializer
    extends StdDeserializer<ActionEnum> {
        public ActionEnumDeserializer() {
            super(ActionEnumDeserializer.class);
        }

        public ActionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ActionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=ServiceNameEnumDeserializer.class)
    public static enum ServiceNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ANALYTICSREPORTING("AnalyticsReporting"),
        ARCHITECT("Architect"),
        COACHING("Coaching"),
        CONTACTCENTER("ContactCenter"),
        CONTENTMANAGEMENT("ContentManagement"),
        DATATABLES("Datatables"),
        DIRECTORY("Directory"),
        DYNAMICSCHEMA("DynamicSchema"),
        GAMIFICATION("Gamification"),
        GROUPS("Groups"),
        INTEGRATIONS("Integrations"),
        KNOWLEDGE("Knowledge"),
        LANGUAGEUNDERSTANDING("LanguageUnderstanding"),
        LEARNING("Learning"),
        LIMITS("Limits"),
        OUTBOUND("Outbound"),
        PEOPLEPERMISSIONS("PeoplePermissions"),
        EMPLOYEEPERFORMANCE("EmployeePerformance"),
        PREDICTIVEENGAGEMENT("PredictiveEngagement"),
        PRESENCE("Presence"),
        QUALITY("Quality"),
        RESPONSEMANAGEMENT("ResponseManagement"),
        ROUTING("Routing"),
        SPEECHANDTEXTANALYTICS("SpeechAndTextAnalytics"),
        TELEPHONY("Telephony"),
        TOPICSDEFINITIONS("TopicsDefinitions"),
        TRIGGERS("Triggers"),
        PROCESSAUTOMATION("ProcessAutomation"),
        VOICEMAIL("Voicemail"),
        WEBDEPLOYMENTS("WebDeployments"),
        WEBHOOKS("Webhooks"),
        WORKFORCEMANAGEMENT("WorkforceManagement"),
        MESSAGING("Messaging"),
        SUPPORTABILITY("Supportability"),
        CALLBACK("Callback"),
        WORKITEMS("Workitems"),
        SCIM("SCIM"),
        NUMBERPURCHASING("NumberPurchasing");

        private String value;

        private ServiceNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServiceNameEnum value : ServiceNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServiceNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ServiceNameEnumDeserializer
    extends StdDeserializer<ServiceNameEnum> {
        public ServiceNameEnumDeserializer() {
            super(ServiceNameEnumDeserializer.class);
        }

        public ServiceNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServiceNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

