/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Reasons for a failed message receipt.")
public class ConversationReason
implements Serializable {
    private CodeEnum code = null;
    private String message = null;

    public ConversationReason code(CodeEnum code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(example="null", value="The reason code for the failed message receipt.")
    @JsonProperty(value="code")
    public CodeEnum getCode() {
        return this.code;
    }

    public void setCode(CodeEnum code) {
        this.code = code;
    }

    public ConversationReason message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Description of the reason for the failed message receipt.")
    @JsonProperty(value="message")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConversationReason conversationReason = (ConversationReason)o;
        return Objects.equals((Object)this.code, (Object)conversationReason.code) && Objects.equals(this.message, conversationReason.message);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.code, this.message});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConversationReason {\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=CodeEnumDeserializer.class)
    public static enum CodeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        MESSAGEEXPIRED("MessageExpired"),
        RATELIMITED("RateLimited"),
        MESSAGENOTALLOWED("MessageNotAllowed"),
        GENERALERROR("GeneralError"),
        UNSUPPORTEDMESSAGE("UnsupportedMessage"),
        UNKNOWNMESSAGE("UnknownMessage"),
        INVALIDMESSAGESTRUCTURE("InvalidMessageStructure"),
        INVALIDDESTINATION("InvalidDestination"),
        SERVERERROR("ServerError"),
        MEDIATYPENOTALLOWED("MediaTypeNotAllowed"),
        INVALIDMEDIACONTENTLENGTH("InvalidMediaContentLength"),
        RECIPIENTOPTEDOUT("RecipientOptedOut");

        private String value;

        private CodeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static CodeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (CodeEnum value : CodeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return CodeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class CodeEnumDeserializer
    extends StdDeserializer<CodeEnum> {
        public CodeEnumDeserializer() {
            super(CodeEnumDeserializer.class);
        }

        public CodeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return CodeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

