/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.TextBotChannel;
import com.mypurecloud.sdk.v2.model.TextBotFlow;
import com.mypurecloud.sdk.v2.model.TextBotInputOutputData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Settings for launching an instance of a bot flow.")
public class TextBotFlowLaunchRequest
implements Serializable {
    private TextBotFlow flow = null;
    private String externalSessionId = null;
    private String conversationId = null;
    private TextBotInputOutputData inputData = null;
    private TextBotChannel channel = null;

    public TextBotFlowLaunchRequest flow(TextBotFlow flow) {
        this.flow = flow;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies which Bot Flow to launch.")
    @JsonProperty(value="flow")
    public TextBotFlow getFlow() {
        return this.flow;
    }

    public void setFlow(TextBotFlow flow) {
        this.flow = flow;
    }

    public TextBotFlowLaunchRequest externalSessionId(String externalSessionId) {
        this.externalSessionId = externalSessionId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The ID of the external session that is associated with the bot flow.")
    @JsonProperty(value="externalSessionId")
    public String getExternalSessionId() {
        return this.externalSessionId;
    }

    public void setExternalSessionId(String externalSessionId) {
        this.externalSessionId = externalSessionId;
    }

    public TextBotFlowLaunchRequest conversationId(String conversationId) {
        this.conversationId = conversationId;
        return this;
    }

    @ApiModelProperty(example="null", value="A conversation ID to associate with the bot flow, if available.")
    @JsonProperty(value="conversationId")
    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public TextBotFlowLaunchRequest inputData(TextBotInputOutputData inputData) {
        this.inputData = inputData;
        return this;
    }

    @ApiModelProperty(example="null", value="Input values to the flow. Valid values are defined by the flow's input JSON schema.")
    @JsonProperty(value="inputData")
    public TextBotInputOutputData getInputData() {
        return this.inputData;
    }

    public void setInputData(TextBotInputOutputData inputData) {
        this.inputData = inputData;
    }

    public TextBotFlowLaunchRequest channel(TextBotChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel information relevant to the bot flow.")
    @JsonProperty(value="channel")
    public TextBotChannel getChannel() {
        return this.channel;
    }

    public void setChannel(TextBotChannel channel) {
        this.channel = channel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextBotFlowLaunchRequest textBotFlowLaunchRequest = (TextBotFlowLaunchRequest)o;
        return Objects.equals(this.flow, textBotFlowLaunchRequest.flow) && Objects.equals(this.externalSessionId, textBotFlowLaunchRequest.externalSessionId) && Objects.equals(this.conversationId, textBotFlowLaunchRequest.conversationId) && Objects.equals(this.inputData, textBotFlowLaunchRequest.inputData) && Objects.equals(this.channel, textBotFlowLaunchRequest.channel);
    }

    public int hashCode() {
        return Objects.hash(this.flow, this.externalSessionId, this.conversationId, this.inputData, this.channel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextBotFlowLaunchRequest {\n");
        sb.append("    flow: ").append(this.toIndentedString(this.flow)).append("\n");
        sb.append("    externalSessionId: ").append(this.toIndentedString(this.externalSessionId)).append("\n");
        sb.append("    conversationId: ").append(this.toIndentedString(this.conversationId)).append("\n");
        sb.append("    inputData: ").append(this.toIndentedString(this.inputData)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

