/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.ScoredAgent;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RoutingData
implements Serializable {
    private String queueId = null;
    private String languageId = null;
    private Integer priority = null;
    private List<String> skillIds = new ArrayList<String>();
    private List<String> preferredAgentIds = new ArrayList<String>();
    private List<ScoredAgent> scoredAgents = new ArrayList<ScoredAgent>();
    private List<String> routingFlags = new ArrayList<String>();

    public RoutingData queueId(String queueId) {
        this.queueId = queueId;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The identifier of the routing queue")
    @JsonProperty(value="queueId")
    public String getQueueId() {
        return this.queueId;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
    }

    public RoutingData languageId(String languageId) {
        this.languageId = languageId;
        return this;
    }

    @ApiModelProperty(example="null", value="The identifier of a language to be considered in routing")
    @JsonProperty(value="languageId")
    public String getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(String languageId) {
        this.languageId = languageId;
    }

    public RoutingData priority(Integer priority) {
        this.priority = priority;
        return this;
    }

    @ApiModelProperty(example="null", value="The priority for routing")
    @JsonProperty(value="priority")
    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public RoutingData skillIds(List<String> skillIds) {
        this.skillIds = skillIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of skill identifiers to be considered in routing")
    @JsonProperty(value="skillIds")
    public List<String> getSkillIds() {
        return this.skillIds;
    }

    public void setSkillIds(List<String> skillIds) {
        this.skillIds = skillIds;
    }

    public RoutingData preferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of agents to be preferred in routing")
    @JsonProperty(value="preferredAgentIds")
    public List<String> getPreferredAgentIds() {
        return this.preferredAgentIds;
    }

    public void setPreferredAgentIds(List<String> preferredAgentIds) {
        this.preferredAgentIds = preferredAgentIds;
    }

    public RoutingData scoredAgents(List<ScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
        return this;
    }

    @ApiModelProperty(example="null", value="A list of scored agents for routing decisions")
    @JsonProperty(value="scoredAgents")
    public List<ScoredAgent> getScoredAgents() {
        return this.scoredAgents;
    }

    public void setScoredAgents(List<ScoredAgent> scoredAgents) {
        this.scoredAgents = scoredAgents;
    }

    public RoutingData routingFlags(List<String> routingFlags) {
        this.routingFlags = routingFlags;
        return this;
    }

    @ApiModelProperty(example="null", value="An array of flags indicating how the conversation should be routed")
    @JsonProperty(value="routingFlags")
    public List<String> getRoutingFlags() {
        return this.routingFlags;
    }

    public void setRoutingFlags(List<String> routingFlags) {
        this.routingFlags = routingFlags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutingData routingData = (RoutingData)o;
        return Objects.equals(this.queueId, routingData.queueId) && Objects.equals(this.languageId, routingData.languageId) && Objects.equals(this.priority, routingData.priority) && Objects.equals(this.skillIds, routingData.skillIds) && Objects.equals(this.preferredAgentIds, routingData.preferredAgentIds) && Objects.equals(this.scoredAgents, routingData.scoredAgents) && Objects.equals(this.routingFlags, routingData.routingFlags);
    }

    public int hashCode() {
        return Objects.hash(this.queueId, this.languageId, this.priority, this.skillIds, this.preferredAgentIds, this.scoredAgents, this.routingFlags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoutingData {\n");
        sb.append("    queueId: ").append(this.toIndentedString(this.queueId)).append("\n");
        sb.append("    languageId: ").append(this.toIndentedString(this.languageId)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString(this.priority)).append("\n");
        sb.append("    skillIds: ").append(this.toIndentedString(this.skillIds)).append("\n");
        sb.append("    preferredAgentIds: ").append(this.toIndentedString(this.preferredAgentIds)).append("\n");
        sb.append("    scoredAgents: ").append(this.toIndentedString(this.scoredAgents)).append("\n");
        sb.append("    routingFlags: ").append(this.toIndentedString(this.routingFlags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

