/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.DevelopmentActivityAggregateQueryRequestFilter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DevelopmentActivityAggregateParam
implements Serializable {
    private String interval = null;
    private List<MetricsEnum> metrics = new ArrayList<MetricsEnum>();
    private List<GroupByEnum> groupBy = new ArrayList<GroupByEnum>();
    private DevelopmentActivityAggregateQueryRequestFilter filter = null;

    public DevelopmentActivityAggregateParam interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Specifies the range of due dates to be used for filtering. Milliseconds will be truncated. A maximum of 1 year can be specified in the range. End date is not inclusive. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public DevelopmentActivityAggregateParam metrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
        return this;
    }

    @ApiModelProperty(example="null", value="The list of metrics to be returned. If omitted, all metrics are returned.")
    @JsonProperty(value="metrics")
    public List<MetricsEnum> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<MetricsEnum> metrics) {
        this.metrics = metrics;
    }

    public DevelopmentActivityAggregateParam groupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies if the aggregated data is combined into a single set of metrics (groupBy is empty or not specified), or contains an element per attendeeId (groupBy is \"attendeeId\")")
    @JsonProperty(value="groupBy")
    public List<GroupByEnum> getGroupBy() {
        return this.groupBy;
    }

    public void setGroupBy(List<GroupByEnum> groupBy) {
        this.groupBy = groupBy;
    }

    public DevelopmentActivityAggregateParam filter(DevelopmentActivityAggregateQueryRequestFilter filter) {
        this.filter = filter;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="The filter applied to the data. This is ANDed with the interval parameter.")
    @JsonProperty(value="filter")
    public DevelopmentActivityAggregateQueryRequestFilter getFilter() {
        return this.filter;
    }

    public void setFilter(DevelopmentActivityAggregateQueryRequestFilter filter) {
        this.filter = filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DevelopmentActivityAggregateParam developmentActivityAggregateParam = (DevelopmentActivityAggregateParam)o;
        return Objects.equals(this.interval, developmentActivityAggregateParam.interval) && Objects.equals(this.metrics, developmentActivityAggregateParam.metrics) && Objects.equals(this.groupBy, developmentActivityAggregateParam.groupBy) && Objects.equals(this.filter, developmentActivityAggregateParam.filter);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.metrics, this.groupBy, this.filter);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DevelopmentActivityAggregateParam {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    groupBy: ").append(this.toIndentedString(this.groupBy)).append("\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=GroupByEnumDeserializer.class)
    public static enum GroupByEnum {
        ATTENDEEID("attendeeId");

        private String value;

        private GroupByEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static GroupByEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (GroupByEnum value : GroupByEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return GroupByEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class GroupByEnumDeserializer
    extends StdDeserializer<GroupByEnum> {
        public GroupByEnumDeserializer() {
            super(GroupByEnumDeserializer.class);
        }

        public GroupByEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return GroupByEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=MetricsEnumDeserializer.class)
    public static enum MetricsEnum {
        NACTIVITIES("nActivities"),
        NPLANNEDACTIVITIES("nPlannedActivities"),
        NINPROGRESSACTIVITIES("nInProgressActivities"),
        NCOMPLETEACTIVITIES("nCompleteActivities"),
        NOVERDUEACTIVITIES("nOverdueActivities"),
        NINVALIDSCHEDULEACTIVITIES("nInvalidScheduleActivities"),
        NPASSEDACTIVITIES("nPassedActivities"),
        NFAILEDACTIVITIES("nFailedActivities"),
        OACTIVITYSCORE("oActivityScore"),
        NNOTCOMPLETEDACTIVITIES("nNotCompletedActivities");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MetricsEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MetricsEnum value : MetricsEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MetricsEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MetricsEnumDeserializer
    extends StdDeserializer<MetricsEnum> {
        public MetricsEnumDeserializer() {
            super(MetricsEnumDeserializer.class);
        }

        public MetricsEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MetricsEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

