/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.MessageMedia;
import com.mypurecloud.sdk.v2.model.MessageSticker;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class MessageDetails
implements Serializable {
    private String messageId = null;
    private String messageURI = null;
    private MessageStatusEnum messageStatus = null;
    private Integer messageSegmentCount = null;
    private Date messageTime = null;
    private List<MessageMedia> media = new ArrayList<MessageMedia>();
    private List<MessageSticker> stickers = new ArrayList<MessageSticker>();

    public MessageDetails messageId(String messageId) {
        this.messageId = messageId;
        return this;
    }

    @ApiModelProperty(example="null", value="UUID identifying the message media.")
    @JsonProperty(value="messageId")
    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public MessageDetails messageURI(String messageURI) {
        this.messageURI = messageURI;
        return this;
    }

    @ApiModelProperty(example="null", value="A URI for this message entity.")
    @JsonProperty(value="messageURI")
    public String getMessageURI() {
        return this.messageURI;
    }

    public void setMessageURI(String messageURI) {
        this.messageURI = messageURI;
    }

    public MessageDetails messageStatus(MessageStatusEnum messageStatus) {
        this.messageStatus = messageStatus;
        return this;
    }

    @ApiModelProperty(example="null", value="Indicates the delivery status of the message.")
    @JsonProperty(value="messageStatus")
    public MessageStatusEnum getMessageStatus() {
        return this.messageStatus;
    }

    public void setMessageStatus(MessageStatusEnum messageStatus) {
        this.messageStatus = messageStatus;
    }

    public MessageDetails messageSegmentCount(Integer messageSegmentCount) {
        this.messageSegmentCount = messageSegmentCount;
        return this;
    }

    @ApiModelProperty(example="null", value="The message segment count, greater than 1 if the message content was split into multiple parts for this message type, e.g. SMS character limits.")
    @JsonProperty(value="messageSegmentCount")
    public Integer getMessageSegmentCount() {
        return this.messageSegmentCount;
    }

    public void setMessageSegmentCount(Integer messageSegmentCount) {
        this.messageSegmentCount = messageSegmentCount;
    }

    public MessageDetails messageTime(Date messageTime) {
        this.messageTime = messageTime;
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the message was sent or received. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="messageTime")
    public Date getMessageTime() {
        return this.messageTime;
    }

    public void setMessageTime(Date messageTime) {
        this.messageTime = messageTime;
    }

    public MessageDetails media(List<MessageMedia> media) {
        this.media = media;
        return this;
    }

    @ApiModelProperty(example="null", value="The media (images, files, etc) associated with this message, if any")
    @JsonProperty(value="media")
    public List<MessageMedia> getMedia() {
        return this.media;
    }

    public void setMedia(List<MessageMedia> media) {
        this.media = media;
    }

    public MessageDetails stickers(List<MessageSticker> stickers) {
        this.stickers = stickers;
        return this;
    }

    @ApiModelProperty(example="null", value="One or more stickers associated with this message, if any")
    @JsonProperty(value="stickers")
    public List<MessageSticker> getStickers() {
        return this.stickers;
    }

    public void setStickers(List<MessageSticker> stickers) {
        this.stickers = stickers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessageDetails messageDetails = (MessageDetails)o;
        return Objects.equals(this.messageId, messageDetails.messageId) && Objects.equals(this.messageURI, messageDetails.messageURI) && Objects.equals((Object)this.messageStatus, (Object)messageDetails.messageStatus) && Objects.equals(this.messageSegmentCount, messageDetails.messageSegmentCount) && Objects.equals(this.messageTime, messageDetails.messageTime) && Objects.equals(this.media, messageDetails.media) && Objects.equals(this.stickers, messageDetails.stickers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageId, this.messageURI, this.messageStatus, this.messageSegmentCount, this.messageTime, this.media, this.stickers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessageDetails {\n");
        sb.append("    messageId: ").append(this.toIndentedString(this.messageId)).append("\n");
        sb.append("    messageURI: ").append(this.toIndentedString(this.messageURI)).append("\n");
        sb.append("    messageStatus: ").append(this.toIndentedString((Object)this.messageStatus)).append("\n");
        sb.append("    messageSegmentCount: ").append(this.toIndentedString(this.messageSegmentCount)).append("\n");
        sb.append("    messageTime: ").append(this.toIndentedString(this.messageTime)).append("\n");
        sb.append("    media: ").append(this.toIndentedString(this.media)).append("\n");
        sb.append("    stickers: ").append(this.toIndentedString(this.stickers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=MessageStatusEnumDeserializer.class)
    public static enum MessageStatusEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("queued"),
        SENT("sent"),
        FAILED("failed"),
        RECEIVED("received"),
        DELIVERY_SUCCESS("delivery-success"),
        DELIVERY_FAILED("delivery-failed"),
        READ("read");

        private String value;

        private MessageStatusEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static MessageStatusEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (MessageStatusEnum value : MessageStatusEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return MessageStatusEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class MessageStatusEnumDeserializer
    extends StdDeserializer<MessageStatusEnum> {
        public MessageStatusEnumDeserializer() {
            super(MessageStatusEnumDeserializer.class);
        }

        public MessageStatusEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return MessageStatusEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

