/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;

public class GetGamificationMetricRequest {
    private String metricId;
    private LocalDate workday;
    private String performanceProfileId;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getMetricId() {
        return this.metricId;
    }

    public void setMetricId(String metricId) {
        this.metricId = metricId;
    }

    public GetGamificationMetricRequest withMetricId(String metricId) {
        this.setMetricId(metricId);
        return this;
    }

    public LocalDate getWorkday() {
        return this.workday;
    }

    public void setWorkday(LocalDate workday) {
        this.workday = workday;
    }

    public GetGamificationMetricRequest withWorkday(LocalDate workday) {
        this.setWorkday(workday);
        return this;
    }

    public String getPerformanceProfileId() {
        return this.performanceProfileId;
    }

    public void setPerformanceProfileId(String performanceProfileId) {
        this.performanceProfileId = performanceProfileId;
    }

    public GetGamificationMetricRequest withPerformanceProfileId(String performanceProfileId) {
        this.setPerformanceProfileId(performanceProfileId);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public GetGamificationMetricRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<Void> withHttpInfo() {
        if (this.metricId == null) {
            throw new IllegalStateException("Missing the required parameter 'metricId' when building request for GetGamificationMetricRequest.");
        }
        return ApiRequestBuilder.create("GET", "/api/v2/gamification/metrics/{metricId}").withPathParameter("metricId", this.metricId).withQueryParameters("workday", "", this.workday).withQueryParameters("performanceProfileId", "", this.performanceProfileId).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String metricId) {
        return new Builder().withRequiredParams(metricId);
    }

    public static class Builder {
        private final GetGamificationMetricRequest request = new GetGamificationMetricRequest();

        private Builder() {
        }

        public Builder withMetricId(String metricId) {
            this.request.setMetricId(metricId);
            return this;
        }

        public Builder withWorkday(LocalDate workday) {
            this.request.setWorkday(workday);
            return this;
        }

        public Builder withPerformanceProfileId(String performanceProfileId) {
            this.request.setPerformanceProfileId(performanceProfileId);
            return this;
        }

        public Builder withRequiredParams(String metricId) {
            this.request.setMetricId(metricId);
            return this;
        }

        public GetGamificationMetricRequest build() {
            if (this.request.metricId == null) {
                throw new IllegalStateException("Missing the required parameter 'metricId' when building request for GetGamificationMetricRequest.");
            }
            return this.request;
        }
    }
}

