/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.CoachingAppointmentStatusRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchCoachingAppointmentStatusRequest {
    private String appointmentId;
    private CoachingAppointmentStatusRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getAppointmentId() {
        return this.appointmentId;
    }

    public void setAppointmentId(String appointmentId) {
        this.appointmentId = appointmentId;
    }

    public PatchCoachingAppointmentStatusRequest withAppointmentId(String appointmentId) {
        this.setAppointmentId(appointmentId);
        return this;
    }

    public CoachingAppointmentStatusRequest getBody() {
        return this.body;
    }

    public void setBody(CoachingAppointmentStatusRequest body) {
        this.body = body;
    }

    public PatchCoachingAppointmentStatusRequest withBody(CoachingAppointmentStatusRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchCoachingAppointmentStatusRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<CoachingAppointmentStatusRequest> withHttpInfo() {
        if (this.appointmentId == null) {
            throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentStatusRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentStatusRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/coaching/appointments/{appointmentId}/status").withPathParameter("appointmentId", this.appointmentId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String appointmentId, CoachingAppointmentStatusRequest body) {
        return new Builder().withRequiredParams(appointmentId, body);
    }

    public static class Builder {
        private final PatchCoachingAppointmentStatusRequest request = new PatchCoachingAppointmentStatusRequest();

        private Builder() {
        }

        public Builder withAppointmentId(String appointmentId) {
            this.request.setAppointmentId(appointmentId);
            return this;
        }

        public Builder withBody(CoachingAppointmentStatusRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String appointmentId, CoachingAppointmentStatusRequest body) {
            this.request.setAppointmentId(appointmentId);
            this.request.setBody(body);
            return this;
        }

        public PatchCoachingAppointmentStatusRequest build() {
            if (this.request.appointmentId == null) {
                throw new IllegalStateException("Missing the required parameter 'appointmentId' when building request for PatchCoachingAppointmentStatusRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchCoachingAppointmentStatusRequest.");
            }
            return this.request;
        }
    }
}

