/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mypurecloud.sdk.v2.model.JsonSchemaDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Output definition of Action.")
public class ActionOutput
implements Serializable {
    private JsonSchemaDocument successSchema = null;
    private String successSchemaUri = null;
    private JsonSchemaDocument errorSchema = null;
    private String errorSchemaUri = null;
    private JsonSchemaDocument successSchemaFlattened = null;
    private Object errorSchemaFlattened = null;

    public ActionOutput successSchema(JsonSchemaDocument successSchema) {
        this.successSchema = successSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON schema that defines the transformed, successful result that will be sent back to the caller. If the 'flatten' query parameter is omitted or false, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.")
    @JsonProperty(value="successSchema")
    public JsonSchemaDocument getSuccessSchema() {
        return this.successSchema;
    }

    public void setSuccessSchema(JsonSchemaDocument successSchema) {
        this.successSchema = successSchema;
    }

    public ActionOutput successSchemaUri(String successSchemaUri) {
        this.successSchemaUri = successSchemaUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI to retrieve success schema")
    @JsonProperty(value="successSchemaUri")
    public String getSuccessSchemaUri() {
        return this.successSchemaUri;
    }

    public void setSuccessSchemaUri(String successSchemaUri) {
        this.successSchemaUri = successSchemaUri;
    }

    public ActionOutput errorSchema(JsonSchemaDocument errorSchema) {
        this.errorSchema = errorSchema;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON schema that defines the body of response when request is not successful. If the 'flatten' query parameter is omitted or false, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.")
    @JsonProperty(value="errorSchema")
    public JsonSchemaDocument getErrorSchema() {
        return this.errorSchema;
    }

    public void setErrorSchema(JsonSchemaDocument errorSchema) {
        this.errorSchema = errorSchema;
    }

    public ActionOutput errorSchemaUri(String errorSchemaUri) {
        this.errorSchemaUri = errorSchemaUri;
        return this;
    }

    @ApiModelProperty(example="null", value="URI to retrieve error schema")
    @JsonProperty(value="errorSchemaUri")
    public String getErrorSchemaUri() {
        return this.errorSchemaUri;
    }

    public void setErrorSchemaUri(String errorSchemaUri) {
        this.errorSchemaUri = errorSchemaUri;
    }

    public ActionOutput successSchemaFlattened(JsonSchemaDocument successSchemaFlattened) {
        this.successSchemaFlattened = successSchemaFlattened;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON schema that defines the transformed, successful result that will be sent back to the caller. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either successSchema or successSchemaFlattened will be returned, not both.")
    @JsonProperty(value="successSchemaFlattened")
    public JsonSchemaDocument getSuccessSchemaFlattened() {
        return this.successSchemaFlattened;
    }

    public void setSuccessSchemaFlattened(JsonSchemaDocument successSchemaFlattened) {
        this.successSchemaFlattened = successSchemaFlattened;
    }

    public ActionOutput errorSchemaFlattened(Object errorSchemaFlattened) {
        this.errorSchemaFlattened = errorSchemaFlattened;
        return this;
    }

    @ApiModelProperty(example="null", value="JSON schema that defines the body of response when request is not successful. The schema is transformed based on Architect's flattened format. If the 'flatten' query parameter is supplied as true, this field will be returned. Either errorSchema or errorSchemaFlattened will be returned, not both.")
    @JsonProperty(value="errorSchemaFlattened")
    public Object getErrorSchemaFlattened() {
        return this.errorSchemaFlattened;
    }

    public void setErrorSchemaFlattened(Object errorSchemaFlattened) {
        this.errorSchemaFlattened = errorSchemaFlattened;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionOutput actionOutput = (ActionOutput)o;
        return Objects.equals(this.successSchema, actionOutput.successSchema) && Objects.equals(this.successSchemaUri, actionOutput.successSchemaUri) && Objects.equals(this.errorSchema, actionOutput.errorSchema) && Objects.equals(this.errorSchemaUri, actionOutput.errorSchemaUri) && Objects.equals(this.successSchemaFlattened, actionOutput.successSchemaFlattened) && Objects.equals(this.errorSchemaFlattened, actionOutput.errorSchemaFlattened);
    }

    public int hashCode() {
        return Objects.hash(this.successSchema, this.successSchemaUri, this.errorSchema, this.errorSchemaUri, this.successSchemaFlattened, this.errorSchemaFlattened);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ActionOutput {\n");
        sb.append("    successSchema: ").append(this.toIndentedString(this.successSchema)).append("\n");
        sb.append("    successSchemaUri: ").append(this.toIndentedString(this.successSchemaUri)).append("\n");
        sb.append("    errorSchema: ").append(this.toIndentedString(this.errorSchema)).append("\n");
        sb.append("    errorSchemaUri: ").append(this.toIndentedString(this.errorSchemaUri)).append("\n");
        sb.append("    successSchemaFlattened: ").append(this.toIndentedString(this.successSchemaFlattened)).append("\n");
        sb.append("    errorSchemaFlattened: ").append(this.toIndentedString(this.errorSchemaFlattened)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

