/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Position settings for messenger")
public class MessengerPositionSettings
implements Serializable {
    private AlignmentEnum alignment = null;
    private Integer sideSpace = null;
    private Integer bottomSpace = null;

    public MessengerPositionSettings alignment(AlignmentEnum alignment) {
        this.alignment = alignment;
        return this;
    }

    @ApiModelProperty(example="null", value="The alignment for messenger position")
    @JsonProperty(value="alignment")
    public AlignmentEnum getAlignment() {
        return this.alignment;
    }

    public void setAlignment(AlignmentEnum alignment) {
        this.alignment = alignment;
    }

    public MessengerPositionSettings sideSpace(Integer sideSpace) {
        this.sideSpace = sideSpace;
        return this;
    }

    @ApiModelProperty(example="null", value="The sidespace value for messenger position")
    @JsonProperty(value="sideSpace")
    public Integer getSideSpace() {
        return this.sideSpace;
    }

    public void setSideSpace(Integer sideSpace) {
        this.sideSpace = sideSpace;
    }

    public MessengerPositionSettings bottomSpace(Integer bottomSpace) {
        this.bottomSpace = bottomSpace;
        return this;
    }

    @ApiModelProperty(example="null", value="The bottomspace value for messenger position")
    @JsonProperty(value="bottomSpace")
    public Integer getBottomSpace() {
        return this.bottomSpace;
    }

    public void setBottomSpace(Integer bottomSpace) {
        this.bottomSpace = bottomSpace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MessengerPositionSettings messengerPositionSettings = (MessengerPositionSettings)o;
        return Objects.equals((Object)this.alignment, (Object)messengerPositionSettings.alignment) && Objects.equals(this.sideSpace, messengerPositionSettings.sideSpace) && Objects.equals(this.bottomSpace, messengerPositionSettings.bottomSpace);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.alignment, this.sideSpace, this.bottomSpace});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MessengerPositionSettings {\n");
        sb.append("    alignment: ").append(this.toIndentedString((Object)this.alignment)).append("\n");
        sb.append("    sideSpace: ").append(this.toIndentedString(this.sideSpace)).append("\n");
        sb.append("    bottomSpace: ").append(this.toIndentedString(this.bottomSpace)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=AlignmentEnumDeserializer.class)
    public static enum AlignmentEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        AUTO("Auto"),
        LEFT("Left"),
        RIGHT("Right");

        private String value;

        private AlignmentEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static AlignmentEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (AlignmentEnum value : AlignmentEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return AlignmentEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class AlignmentEnumDeserializer
    extends StdDeserializer<AlignmentEnum> {
        public AlignmentEnumDeserializer() {
            super(AlignmentEnumDeserializer.class);
        }

        public AlignmentEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return AlignmentEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

