/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.KnowledgeContextValueRequest;
import java.util.HashMap;
import java.util.Map;

public class PatchKnowledgeKnowledgebaseContextValueRequest {
    private String knowledgeBaseId;
    private String contextId;
    private String contextValueId;
    private KnowledgeContextValueRequest body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getKnowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public void setKnowledgeBaseId(String knowledgeBaseId) {
        this.knowledgeBaseId = knowledgeBaseId;
    }

    public PatchKnowledgeKnowledgebaseContextValueRequest withKnowledgeBaseId(String knowledgeBaseId) {
        this.setKnowledgeBaseId(knowledgeBaseId);
        return this;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public PatchKnowledgeKnowledgebaseContextValueRequest withContextId(String contextId) {
        this.setContextId(contextId);
        return this;
    }

    public String getContextValueId() {
        return this.contextValueId;
    }

    public void setContextValueId(String contextValueId) {
        this.contextValueId = contextValueId;
    }

    public PatchKnowledgeKnowledgebaseContextValueRequest withContextValueId(String contextValueId) {
        this.setContextValueId(contextValueId);
        return this;
    }

    public KnowledgeContextValueRequest getBody() {
        return this.body;
    }

    public void setBody(KnowledgeContextValueRequest body) {
        this.body = body;
    }

    public PatchKnowledgeKnowledgebaseContextValueRequest withBody(KnowledgeContextValueRequest body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchKnowledgeKnowledgebaseContextValueRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<KnowledgeContextValueRequest> withHttpInfo() {
        if (this.knowledgeBaseId == null) {
            throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
        }
        if (this.contextId == null) {
            throw new IllegalStateException("Missing the required parameter 'contextId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
        }
        if (this.contextValueId == null) {
            throw new IllegalStateException("Missing the required parameter 'contextValueId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/knowledge/knowledgebases/{knowledgeBaseId}/contexts/{contextId}/values/{contextValueId}").withPathParameter("knowledgeBaseId", this.knowledgeBaseId).withPathParameter("contextId", this.contextId).withPathParameter("contextValueId", this.contextValueId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String knowledgeBaseId, String contextId, String contextValueId) {
        return new Builder().withRequiredParams(knowledgeBaseId, contextId, contextValueId);
    }

    public static class Builder {
        private final PatchKnowledgeKnowledgebaseContextValueRequest request = new PatchKnowledgeKnowledgebaseContextValueRequest();

        private Builder() {
        }

        public Builder withKnowledgeBaseId(String knowledgeBaseId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            return this;
        }

        public Builder withContextId(String contextId) {
            this.request.setContextId(contextId);
            return this;
        }

        public Builder withContextValueId(String contextValueId) {
            this.request.setContextValueId(contextValueId);
            return this;
        }

        public Builder withBody(KnowledgeContextValueRequest body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String knowledgeBaseId, String contextId, String contextValueId) {
            this.request.setKnowledgeBaseId(knowledgeBaseId);
            this.request.setContextId(contextId);
            this.request.setContextValueId(contextValueId);
            return this;
        }

        public PatchKnowledgeKnowledgebaseContextValueRequest build() {
            if (this.request.knowledgeBaseId == null) {
                throw new IllegalStateException("Missing the required parameter 'knowledgeBaseId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
            }
            if (this.request.contextId == null) {
                throw new IllegalStateException("Missing the required parameter 'contextId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
            }
            if (this.request.contextValueId == null) {
                throw new IllegalStateException("Missing the required parameter 'contextValueId' when building request for PatchKnowledgeKnowledgebaseContextValueRequest.");
            }
            return this.request;
        }
    }
}

