/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mypurecloud.sdk.v2.ApiClient;
import com.mypurecloud.sdk.v2.ApiException;
import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiResponse;
import com.mypurecloud.sdk.v2.Configuration;
import com.mypurecloud.sdk.v2.api.request.GetWebmessagingMessagesRequest;
import com.mypurecloud.sdk.v2.model.WebMessagingMessageEntityList;
import java.io.IOException;

public class WebMessagingApi {
    private final ApiClient pcapiClient;

    public WebMessagingApi() {
        this(Configuration.getDefaultApiClient());
    }

    public WebMessagingApi(ApiClient apiClient) {
        this.pcapiClient = apiClient;
    }

    public WebMessagingMessageEntityList getWebmessagingMessages(Integer pageSize, Integer pageNumber) throws IOException, ApiException {
        return this.getWebmessagingMessages(this.createGetWebmessagingMessagesRequest(pageSize, pageNumber));
    }

    public ApiResponse<WebMessagingMessageEntityList> getWebmessagingMessagesWithHttpInfo(Integer pageSize, Integer pageNumber) throws IOException {
        return this.getWebmessagingMessages(this.createGetWebmessagingMessagesRequest(pageSize, pageNumber).withHttpInfo());
    }

    private GetWebmessagingMessagesRequest createGetWebmessagingMessagesRequest(Integer pageSize, Integer pageNumber) {
        return GetWebmessagingMessagesRequest.builder().withPageSize(pageSize).withPageNumber(pageNumber).build();
    }

    public WebMessagingMessageEntityList getWebmessagingMessages(GetWebmessagingMessagesRequest request) throws IOException, ApiException {
        try {
            ApiResponse<WebMessagingMessageEntityList> response = this.pcapiClient.invoke(request.withHttpInfo(), new TypeReference<WebMessagingMessageEntityList>(){});
            return response.getBody();
        }
        catch (ApiException | IOException exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                throw exception;
            }
            return null;
        }
    }

    public ApiResponse<WebMessagingMessageEntityList> getWebmessagingMessages(ApiRequest<Void> request) throws IOException {
        try {
            return this.pcapiClient.invoke(request, new TypeReference<WebMessagingMessageEntityList>(){});
        }
        catch (ApiException exception) {
            ApiException response = exception;
            return response;
        }
        catch (Throwable exception) {
            if (this.pcapiClient.getShouldThrowErrors()) {
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new RuntimeException(exception);
            }
            ApiException response = new ApiException(exception);
            return response;
        }
    }
}

