/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.AuditQueryFilter;
import com.mypurecloud.sdk.v2.model.AuditQuerySort;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class AuditQueryExecutionStatusResponse
implements Serializable {
    private String id = null;
    private StateEnum state = null;
    private Date startDate = null;
    private String interval = null;
    private ServiceNameEnum serviceName = null;
    private List<AuditQueryFilter> filters = new ArrayList<AuditQueryFilter>();
    private List<AuditQuerySort> sort = new ArrayList<AuditQuerySort>();

    public AuditQueryExecutionStatusResponse id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Id of the audit query execution request.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public AuditQueryExecutionStatusResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="Status of the audit query execution request.")
    @JsonProperty(value="state")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public AuditQueryExecutionStatusResponse startDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(example="null", value="Start date and time of the audit query execution. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z")
    @JsonProperty(value="startDate")
    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public AuditQueryExecutionStatusResponse interval(String interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(example="null", value="Interval for the audit query. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss")
    @JsonProperty(value="interval")
    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public AuditQueryExecutionStatusResponse serviceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Service name for the audit query.")
    @JsonProperty(value="serviceName")
    public ServiceNameEnum getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(ServiceNameEnum serviceName) {
        this.serviceName = serviceName;
    }

    public AuditQueryExecutionStatusResponse filters(List<AuditQueryFilter> filters) {
        this.filters = filters;
        return this;
    }

    @ApiModelProperty(example="null", value="Filters for the audit query.")
    @JsonProperty(value="filters")
    public List<AuditQueryFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<AuditQueryFilter> filters) {
        this.filters = filters;
    }

    public AuditQueryExecutionStatusResponse sort(List<AuditQuerySort> sort) {
        this.sort = sort;
        return this;
    }

    @ApiModelProperty(example="null", value="Sort parameter for the audit query.")
    @JsonProperty(value="sort")
    public List<AuditQuerySort> getSort() {
        return this.sort;
    }

    public void setSort(List<AuditQuerySort> sort) {
        this.sort = sort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditQueryExecutionStatusResponse auditQueryExecutionStatusResponse = (AuditQueryExecutionStatusResponse)o;
        return Objects.equals(this.id, auditQueryExecutionStatusResponse.id) && Objects.equals((Object)this.state, (Object)auditQueryExecutionStatusResponse.state) && Objects.equals(this.startDate, auditQueryExecutionStatusResponse.startDate) && Objects.equals(this.interval, auditQueryExecutionStatusResponse.interval) && Objects.equals((Object)this.serviceName, (Object)auditQueryExecutionStatusResponse.serviceName) && Objects.equals(this.filters, auditQueryExecutionStatusResponse.filters) && Objects.equals(this.sort, auditQueryExecutionStatusResponse.sort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.state, this.startDate, this.interval, this.serviceName, this.filters, this.sort});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuditQueryExecutionStatusResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString((Object)this.serviceName)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    sort: ").append(this.toIndentedString(this.sort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=ServiceNameEnumDeserializer.class)
    public static enum ServiceNameEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        ANALYTICSREPORTING("AnalyticsReporting"),
        ARCHITECT("Architect"),
        COACHING("Coaching"),
        CONTACTCENTER("ContactCenter"),
        CONTENTMANAGEMENT("ContentManagement"),
        DATATABLES("Datatables"),
        GAMIFICATION("Gamification"),
        GROUPS("Groups"),
        INTEGRATIONS("Integrations"),
        KNOWLEDGE("Knowledge"),
        LANGUAGEUNDERSTANDING("LanguageUnderstanding"),
        LEARNING("Learning"),
        LIMITS("Limits"),
        OUTBOUND("Outbound"),
        PEOPLEPERMISSIONS("PeoplePermissions"),
        EMPLOYEEPERFORMANCE("EmployeePerformance"),
        PREDICTIVEENGAGEMENT("PredictiveEngagement"),
        PRESENCE("Presence"),
        QUALITY("Quality"),
        RESPONSEMANAGEMENT("ResponseManagement"),
        ROUTING("Routing"),
        SPEECHANDTEXTANALYTICS("SpeechAndTextAnalytics"),
        TELEPHONY("Telephony"),
        TOPICSDEFINITIONS("TopicsDefinitions"),
        TRIGGERS("Triggers"),
        PROCESSAUTOMATION("ProcessAutomation"),
        WEBDEPLOYMENTS("WebDeployments"),
        WEBHOOKS("Webhooks"),
        WORKFORCEMANAGEMENT("WorkforceManagement"),
        MESSAGING("Messaging"),
        SUPPORTABILITY("Supportability"),
        CALLBACK("Callback");

        private String value;

        private ServiceNameEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static ServiceNameEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (ServiceNameEnum value : ServiceNameEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return ServiceNameEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class ServiceNameEnumDeserializer
    extends StdDeserializer<ServiceNameEnum> {
        public ServiceNameEnumDeserializer() {
            super(ServiceNameEnumDeserializer.class);
        }

        public ServiceNameEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return ServiceNameEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=StateEnumDeserializer.class)
    public static enum StateEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        QUEUED("Queued"),
        RUNNING("Running"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed"),
        CANCELLED("Cancelled");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static StateEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (StateEnum value : StateEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return StateEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class StateEnumDeserializer
    extends StdDeserializer<StateEnum> {
        public StateEnumDeserializer() {
            super(StateEnumDeserializer.class);
        }

        public StateEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return StateEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

