/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.mypurecloud.sdk.v2.model.OpenMessageContent;
import com.mypurecloud.sdk.v2.model.OpenMessagingChannel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Open Messaging rich media message structure")
public class OpenNormalizedMessage
implements Serializable {
    private String id = null;
    private OpenMessagingChannel channel = null;
    private TypeEnum type = null;
    private String text = null;
    private List<OpenMessageContent> content = new ArrayList<OpenMessageContent>();
    private DirectionEnum direction = null;

    @ApiModelProperty(example="null", value="Unique ID of the message. This ID is generated by Messaging Platform. Message receipts will have the same ID as the message they reference.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public OpenNormalizedMessage channel(OpenMessagingChannel channel) {
        this.channel = channel;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Channel-specific information that describes the message and the message channel/provider.")
    @JsonProperty(value="channel")
    public OpenMessagingChannel getChannel() {
        return this.channel;
    }

    public void setChannel(OpenMessagingChannel channel) {
        this.channel = channel;
    }

    public OpenNormalizedMessage type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(example="null", required=true, value="Message type.")
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public OpenNormalizedMessage text(String text) {
        this.text = text;
        return this;
    }

    @ApiModelProperty(example="null", value="Message text.")
    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public OpenNormalizedMessage content(List<OpenMessageContent> content) {
        this.content = content;
        return this;
    }

    @ApiModelProperty(example="null", value="List of content elements.")
    @JsonProperty(value="content")
    public List<OpenMessageContent> getContent() {
        return this.content;
    }

    public void setContent(List<OpenMessageContent> content) {
        this.content = content;
    }

    @ApiModelProperty(example="null", value="The direction of the message.")
    @JsonProperty(value="direction")
    public DirectionEnum getDirection() {
        return this.direction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenNormalizedMessage openNormalizedMessage = (OpenNormalizedMessage)o;
        return Objects.equals(this.id, openNormalizedMessage.id) && Objects.equals(this.channel, openNormalizedMessage.channel) && Objects.equals((Object)this.type, (Object)openNormalizedMessage.type) && Objects.equals(this.text, openNormalizedMessage.text) && Objects.equals(this.content, openNormalizedMessage.content) && Objects.equals((Object)this.direction, (Object)openNormalizedMessage.direction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.channel, this.type, this.text, this.content, this.direction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenNormalizedMessage {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    channel: ").append(this.toIndentedString(this.channel)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    text: ").append(this.toIndentedString(this.text)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    direction: ").append(this.toIndentedString((Object)this.direction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonDeserialize(using=DirectionEnumDeserializer.class)
    public static enum DirectionEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        INBOUND("Inbound"),
        OUTBOUND("Outbound");

        private String value;

        private DirectionEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static DirectionEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (DirectionEnum value : DirectionEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return DirectionEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class DirectionEnumDeserializer
    extends StdDeserializer<DirectionEnum> {
        public DirectionEnumDeserializer() {
            super(DirectionEnumDeserializer.class);
        }

        public DirectionEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return DirectionEnum.fromString(node.toString().replace("\"", ""));
        }
    }

    @JsonDeserialize(using=TypeEnumDeserializer.class)
    public static enum TypeEnum {
        OUTDATEDSDKVERSION("OutdatedSdkVersion"),
        TEXT("Text");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonCreator
        public static TypeEnum fromString(String key) {
            if (key == null) {
                return null;
            }
            for (TypeEnum value : TypeEnum.values()) {
                if (!key.equalsIgnoreCase(value.toString())) continue;
                return value;
            }
            return TypeEnum.values()[0];
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    private static class TypeEnumDeserializer
    extends StdDeserializer<TypeEnum> {
        public TypeEnumDeserializer() {
            super(TypeEnumDeserializer.class);
        }

        public TypeEnum deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
            return TypeEnum.fromString(node.toString().replace("\"", ""));
        }
    }
}

