/*
 * Decompiled with CFR 0.152.
 */
package com.mypurecloud.sdk.v2.api.request;

import com.mypurecloud.sdk.v2.ApiRequest;
import com.mypurecloud.sdk.v2.ApiRequestBuilder;
import com.mypurecloud.sdk.v2.model.RoutingConversationAttributes;
import java.util.HashMap;
import java.util.Map;

public class PatchRoutingConversationRequest {
    private String conversationId;
    private RoutingConversationAttributes body;
    private final Map<String, String> customHeaders = new HashMap<String, String>();

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public PatchRoutingConversationRequest withConversationId(String conversationId) {
        this.setConversationId(conversationId);
        return this;
    }

    public RoutingConversationAttributes getBody() {
        return this.body;
    }

    public void setBody(RoutingConversationAttributes body) {
        this.body = body;
    }

    public PatchRoutingConversationRequest withBody(RoutingConversationAttributes body) {
        this.setBody(body);
        return this;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders.clear();
        this.customHeaders.putAll(customHeaders);
    }

    public void addCustomHeader(String name, String value) {
        this.customHeaders.put(name, value);
    }

    public PatchRoutingConversationRequest withCustomHeader(String name, String value) {
        this.addCustomHeader(name, value);
        return this;
    }

    public ApiRequest<RoutingConversationAttributes> withHttpInfo() {
        if (this.conversationId == null) {
            throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchRoutingConversationRequest.");
        }
        if (this.body == null) {
            throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingConversationRequest.");
        }
        return ApiRequestBuilder.create("PATCH", "/api/v2/routing/conversations/{conversationId}").withPathParameter("conversationId", this.conversationId).withBody(this.body).withCustomHeaders(this.customHeaders).withContentTypes("application/json").withAccepts("application/json").withAuthNames("PureCloud OAuth").build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String conversationId, RoutingConversationAttributes body) {
        return new Builder().withRequiredParams(conversationId, body);
    }

    public static class Builder {
        private final PatchRoutingConversationRequest request = new PatchRoutingConversationRequest();

        private Builder() {
        }

        public Builder withConversationId(String conversationId) {
            this.request.setConversationId(conversationId);
            return this;
        }

        public Builder withBody(RoutingConversationAttributes body) {
            this.request.setBody(body);
            return this;
        }

        public Builder withRequiredParams(String conversationId, RoutingConversationAttributes body) {
            this.request.setConversationId(conversationId);
            this.request.setBody(body);
            return this;
        }

        public PatchRoutingConversationRequest build() {
            if (this.request.conversationId == null) {
                throw new IllegalStateException("Missing the required parameter 'conversationId' when building request for PatchRoutingConversationRequest.");
            }
            if (this.request.body == null) {
                throw new IllegalStateException("Missing the required parameter 'body' when building request for PatchRoutingConversationRequest.");
            }
            return this.request;
        }
    }
}

